/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.jess.arms.base.Platform;
import com.zhy.autolayout.AutoFrameLayout;
import com.zhy.autolayout.AutoLinearLayout;
import com.zhy.autolayout.AutoRelativeLayout;

public class ThirdViewUtil {
    private static int HAS_AUTO_LAYOUT_META = -1;

    private ThirdViewUtil() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static boolean isUseAutolayout() {
        return Platform.DEPENDENCY_AUTO_LAYOUT && HAS_AUTO_LAYOUT_META == 1;
    }

    public static Unbinder bindTarget(Object target, Object source) {
        if (source instanceof Activity) {
            return ButterKnife.bind((Object)target, (Activity)((Activity)source));
        }
        if (source instanceof View) {
            return ButterKnife.bind((Object)target, (View)((View)source));
        }
        if (source instanceof Dialog) {
            return ButterKnife.bind((Object)target, (Dialog)((Dialog)source));
        }
        return Unbinder.EMPTY;
    }

    @Nullable
    public static View convertAutoView(String name, Context context, AttributeSet attrs) {
        if (!Platform.DEPENDENCY_AUTO_LAYOUT) {
            return null;
        }
        if (HAS_AUTO_LAYOUT_META == -1) {
            HAS_AUTO_LAYOUT_META = 1;
            PackageManager packageManager = context.getPackageManager();
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
                if (applicationInfo == null || applicationInfo.metaData == null || !applicationInfo.metaData.containsKey("design_width") || !applicationInfo.metaData.containsKey("design_height")) {
                    HAS_AUTO_LAYOUT_META = 0;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                HAS_AUTO_LAYOUT_META = 0;
            }
        }
        if (HAS_AUTO_LAYOUT_META == 0) {
            return null;
        }
        AutoFrameLayout view = null;
        if (name.equals("FrameLayout")) {
            view = new AutoFrameLayout(context, attrs);
        } else if (name.equals("LinearLayout")) {
            view = new AutoLinearLayout(context, attrs);
        } else if (name.equals("RelativeLayout")) {
            view = new AutoRelativeLayout(context, attrs);
        }
        return view;
    }
}

