/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import com.jess.arms.integration.lifecycle.ActivityLifecycleable;
import com.jess.arms.integration.lifecycle.FragmentLifecycleable;
import com.jess.arms.integration.lifecycle.Lifecycleable;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.Preconditions;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.RxLifecycle;
import com.trello.rxlifecycle2.android.ActivityEvent;
import com.trello.rxlifecycle2.android.FragmentEvent;
import com.trello.rxlifecycle2.android.RxLifecycleAndroid;
import io.reactivex.annotations.NonNull;

public class RxLifecycleUtils {
    private RxLifecycleUtils() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static <T> LifecycleTransformer<T> bindUntilEvent(@NonNull IView view, ActivityEvent event) {
        Preconditions.checkNotNull(view, "view == null");
        if (view instanceof ActivityLifecycleable) {
            return RxLifecycleUtils.bindUntilEvent((ActivityLifecycleable)((Object)view), event);
        }
        throw new IllegalArgumentException("view isn't ActivityLifecycleable");
    }

    public static <T> LifecycleTransformer<T> bindUntilEvent(@NonNull IView view, FragmentEvent event) {
        Preconditions.checkNotNull(view, "view == null");
        if (view instanceof FragmentLifecycleable) {
            return RxLifecycleUtils.bindUntilEvent((FragmentLifecycleable)((Object)view), event);
        }
        throw new IllegalArgumentException("view isn't FragmentLifecycleable");
    }

    public static <T, R> LifecycleTransformer<T> bindUntilEvent(@NonNull Lifecycleable<R> lifecycleable, R event) {
        Preconditions.checkNotNull(lifecycleable, "lifecycleable == null");
        return RxLifecycle.bindUntilEvent(lifecycleable.provideLifecycleSubject(), event);
    }

    public static <T> LifecycleTransformer<T> bindToLifecycle(@NonNull IView view) {
        Preconditions.checkNotNull(view, "view == null");
        if (view instanceof Lifecycleable) {
            return RxLifecycleUtils.bindToLifecycle((Lifecycleable)((Object)view));
        }
        throw new IllegalArgumentException("view isn't Lifecycleable");
    }

    public static <T> LifecycleTransformer<T> bindToLifecycle(@NonNull Lifecycleable lifecycleable) {
        Preconditions.checkNotNull(lifecycleable, "lifecycleable == null");
        if (lifecycleable instanceof ActivityLifecycleable) {
            return RxLifecycleAndroid.bindActivity(((ActivityLifecycleable)lifecycleable).provideLifecycleSubject());
        }
        if (lifecycleable instanceof FragmentLifecycleable) {
            return RxLifecycleAndroid.bindFragment(((FragmentLifecycleable)lifecycleable).provideLifecycleSubject());
        }
        throw new IllegalArgumentException("Lifecycleable not match");
    }
}

