/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.http.imageloader.glide;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.CheckResult;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.jess.arms.http.imageloader.glide.GlideOptions;
import java.io.File;
import java.net.URL;

public class GlideRequest<TranscodeType>
extends RequestBuilder<TranscodeType>
implements Cloneable {
    GlideRequest(@NonNull Class<TranscodeType> transcodeClass, @NonNull RequestBuilder<?> other) {
        super(transcodeClass, other);
    }

    GlideRequest(@NonNull Glide glide, @NonNull RequestManager requestManager, @NonNull Class<TranscodeType> transcodeClass, @NonNull Context context) {
        super(glide, requestManager, transcodeClass, context);
    }

    @CheckResult
    @NonNull
    protected GlideRequest<File> getDownloadOnlyRequest() {
        return new GlideRequest<File>(File.class, this).apply(DOWNLOAD_ONLY_OPTIONS);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> sizeMultiplier(@FloatRange(from=0.0, to=1.0) float value) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).sizeMultiplier(value) : new GlideOptions().apply(this.requestOptions).sizeMultiplier(value);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> useUnlimitedSourceGeneratorsPool(boolean flag) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).useUnlimitedSourceGeneratorsPool(flag) : new GlideOptions().apply(this.requestOptions).useUnlimitedSourceGeneratorsPool(flag);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> useAnimationPool(boolean flag) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).useAnimationPool(flag) : new GlideOptions().apply(this.requestOptions).useAnimationPool(flag);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> onlyRetrieveFromCache(boolean flag) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).onlyRetrieveFromCache(flag) : new GlideOptions().apply(this.requestOptions).onlyRetrieveFromCache(flag);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> diskCacheStrategy(@NonNull DiskCacheStrategy strategy) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).diskCacheStrategy(strategy) : new GlideOptions().apply(this.requestOptions).diskCacheStrategy(strategy);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> priority(@NonNull Priority priority) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).priority(priority) : new GlideOptions().apply(this.requestOptions).priority(priority);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> placeholder(@Nullable Drawable drawable) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).placeholder(drawable) : new GlideOptions().apply(this.requestOptions).placeholder(drawable);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> placeholder(@DrawableRes int id) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).placeholder(id) : new GlideOptions().apply(this.requestOptions).placeholder(id);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> fallback(@Nullable Drawable drawable) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).fallback(drawable) : new GlideOptions().apply(this.requestOptions).fallback(drawable);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> fallback(@DrawableRes int id) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).fallback(id) : new GlideOptions().apply(this.requestOptions).fallback(id);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> error(@Nullable Drawable drawable) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).error(drawable) : new GlideOptions().apply(this.requestOptions).error(drawable);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> error(@DrawableRes int id) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).error(id) : new GlideOptions().apply(this.requestOptions).error(id);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> theme(@Nullable Resources.Theme theme) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).theme(theme) : new GlideOptions().apply(this.requestOptions).theme(theme);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> skipMemoryCache(boolean skip) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).skipMemoryCache(skip) : new GlideOptions().apply(this.requestOptions).skipMemoryCache(skip);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> override(int width, int height) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).override(width, height) : new GlideOptions().apply(this.requestOptions).override(width, height);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> override(int size) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).override(size) : new GlideOptions().apply(this.requestOptions).override(size);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> signature(@NonNull Key key) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).signature(key) : new GlideOptions().apply(this.requestOptions).signature(key);
        return this;
    }

    @NonNull
    @CheckResult
    public <T> GlideRequest<TranscodeType> set(@NonNull Option<T> option, @NonNull T t) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).set((Option)option, (Object)t) : new GlideOptions().apply(this.requestOptions).set((Option)option, (Object)t);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> decode(@NonNull Class<?> clazz) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).decode((Class)clazz) : new GlideOptions().apply(this.requestOptions).decode((Class)clazz);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> encodeFormat(@NonNull Bitmap.CompressFormat format) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).encodeFormat(format) : new GlideOptions().apply(this.requestOptions).encodeFormat(format);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> encodeQuality(@IntRange(from=0L, to=100L) int value) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).encodeQuality(value) : new GlideOptions().apply(this.requestOptions).encodeQuality(value);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> frame(@IntRange(from=0L) long value) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).frame(value) : new GlideOptions().apply(this.requestOptions).frame(value);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> format(@NonNull DecodeFormat format) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).format(format) : new GlideOptions().apply(this.requestOptions).format(format);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> disallowHardwareConfig() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).disallowHardwareConfig() : new GlideOptions().apply(this.requestOptions).disallowHardwareConfig();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> downsample(@NonNull DownsampleStrategy strategy) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).downsample(strategy) : new GlideOptions().apply(this.requestOptions).downsample(strategy);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> timeout(@IntRange(from=0L) int value) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).timeout(value) : new GlideOptions().apply(this.requestOptions).timeout(value);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> optionalCenterCrop() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).optionalCenterCrop() : new GlideOptions().apply(this.requestOptions).optionalCenterCrop();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> centerCrop() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).centerCrop() : new GlideOptions().apply(this.requestOptions).centerCrop();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> optionalFitCenter() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).optionalFitCenter() : new GlideOptions().apply(this.requestOptions).optionalFitCenter();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> fitCenter() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).fitCenter() : new GlideOptions().apply(this.requestOptions).fitCenter();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> optionalCenterInside() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).optionalCenterInside() : new GlideOptions().apply(this.requestOptions).optionalCenterInside();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> centerInside() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).centerInside() : new GlideOptions().apply(this.requestOptions).centerInside();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> optionalCircleCrop() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).optionalCircleCrop() : new GlideOptions().apply(this.requestOptions).optionalCircleCrop();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> circleCrop() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).circleCrop() : new GlideOptions().apply(this.requestOptions).circleCrop();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> transform(@NonNull Transformation<Bitmap> transformation) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).transform((Transformation)transformation) : new GlideOptions().apply(this.requestOptions).transform((Transformation)transformation);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> transforms(Transformation<Bitmap> ... transformations) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).transforms((Transformation[])transformations) : new GlideOptions().apply(this.requestOptions).transforms((Transformation[])transformations);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> optionalTransform(@NonNull Transformation<Bitmap> transformation) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).optionalTransform((Transformation)transformation) : new GlideOptions().apply(this.requestOptions).optionalTransform((Transformation)transformation);
        return this;
    }

    @NonNull
    @CheckResult
    public <T> GlideRequest<TranscodeType> optionalTransform(@NonNull Class<T> clazz, @NonNull Transformation<T> transformation) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).optionalTransform((Class)clazz, (Transformation)transformation) : new GlideOptions().apply(this.requestOptions).optionalTransform((Class)clazz, (Transformation)transformation);
        return this;
    }

    @NonNull
    @CheckResult
    public <T> GlideRequest<TranscodeType> transform(@NonNull Class<T> clazz, @NonNull Transformation<T> transformation) {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).transform((Class)clazz, (Transformation)transformation) : new GlideOptions().apply(this.requestOptions).transform((Class)clazz, (Transformation)transformation);
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> dontTransform() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).dontTransform() : new GlideOptions().apply(this.requestOptions).dontTransform();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> dontAnimate() {
        this.requestOptions = this.getMutableOptions() instanceof GlideOptions ? ((GlideOptions)this.getMutableOptions()).dontAnimate() : new GlideOptions().apply(this.requestOptions).dontAnimate();
        return this;
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> apply(@NonNull RequestOptions options) {
        return (GlideRequest)super.apply(options);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> transition(@NonNull TransitionOptions<?, ? super TranscodeType> options) {
        return (GlideRequest)super.transition(options);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> listener(@Nullable RequestListener<TranscodeType> listener) {
        return (GlideRequest)super.listener(listener);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> addListener(@Nullable RequestListener<TranscodeType> listener) {
        return (GlideRequest)super.addListener(listener);
    }

    @NonNull
    public GlideRequest<TranscodeType> error(@Nullable RequestBuilder<TranscodeType> builder) {
        return (GlideRequest)super.error(builder);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> thumbnail(@Nullable RequestBuilder<TranscodeType> builder) {
        return (GlideRequest)super.thumbnail(builder);
    }

    @SafeVarargs
    @NonNull
    @CheckResult
    public final GlideRequest<TranscodeType> thumbnail(RequestBuilder<TranscodeType> ... builders) {
        return (GlideRequest)super.thumbnail(builders);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> thumbnail(float sizeMultiplier) {
        return (GlideRequest)super.thumbnail(sizeMultiplier);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable Object o) {
        return (GlideRequest)super.load(o);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable Bitmap bitmap) {
        return (GlideRequest)super.load(bitmap);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable Drawable drawable) {
        return (GlideRequest)super.load(drawable);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable String string) {
        return (GlideRequest)super.load(string);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable Uri uri) {
        return (GlideRequest)super.load(uri);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable File file) {
        return (GlideRequest)super.load(file);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@RawRes @DrawableRes @Nullable Integer id) {
        return (GlideRequest)super.load(id);
    }

    @Deprecated
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable URL url) {
        return (GlideRequest)super.load(url);
    }

    @NonNull
    @CheckResult
    public GlideRequest<TranscodeType> load(@Nullable byte[] bytes) {
        return (GlideRequest)super.load(bytes);
    }

    @CheckResult
    public GlideRequest<TranscodeType> clone() {
        return (GlideRequest)super.clone();
    }
}

