/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import com.jess.arms.base.App;
import com.jess.arms.base.delegate.AppDelegate;
import com.jess.arms.base.delegate.AppLifecycles;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.Preconditions;

public class BaseApplication
extends Application
implements App {
    private AppLifecycles mAppDelegate;

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        if (this.mAppDelegate == null) {
            this.mAppDelegate = new AppDelegate(base);
        }
        this.mAppDelegate.attachBaseContext(base);
    }

    public void onCreate() {
        super.onCreate();
        if (this.mAppDelegate != null) {
            this.mAppDelegate.onCreate(this);
        }
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.mAppDelegate != null) {
            this.mAppDelegate.onTerminate(this);
        }
    }

    @Override
    @NonNull
    public AppComponent getAppComponent() {
        Preconditions.checkNotNull(this.mAppDelegate, "%s cannot be null", AppDelegate.class.getName());
        Preconditions.checkState(this.mAppDelegate instanceof App, "%s must be implements %s", AppDelegate.class.getName(), App.class.getName());
        return ((App)((Object)this.mAppDelegate)).getAppComponent();
    }
}

