/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.http.imageloader.glide;

import android.graphics.Bitmap;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.jess.arms.utils.FastBlur;
import java.security.MessageDigest;

public class BlurTransformation
extends BitmapTransformation {
    private static final String ID = BlurTransformation.class.getName();
    private static final byte[] ID_BYTES = ID.getBytes(Key.CHARSET);
    public static final int DEFAULT_RADIUS = 15;
    private int mRadius = 15;

    public BlurTransformation(@IntRange(from=0L) int radius) {
        this.mRadius = radius;
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        return FastBlur.doBlur(toTransform, this.mRadius, true);
    }

    public boolean equals(Object o) {
        return o instanceof BlurTransformation;
    }

    public int hashCode() {
        return ID.hashCode();
    }
}

