/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base.delegate;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.jess.arms.base.delegate.FragmentDelegate;
import com.jess.arms.base.delegate.IFragment;
import com.jess.arms.utils.ArmsUtils;
import org.simple.eventbus.EventBus;
import timber.log.Timber;

public class FragmentDelegateImpl
implements FragmentDelegate {
    private FragmentManager mFragmentManager;
    private Fragment mFragment;
    private IFragment iFragment;
    private Unbinder mUnbinder;

    public FragmentDelegateImpl(FragmentManager fragmentManager, Fragment fragment) {
        this.mFragmentManager = fragmentManager;
        this.mFragment = fragment;
        this.iFragment = (IFragment)fragment;
    }

    @Override
    public void onAttach(Context context) {
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (this.iFragment.useEventBus()) {
            EventBus.getDefault().register((Object)this.mFragment);
        }
        this.iFragment.setupFragmentComponent(ArmsUtils.obtainAppComponentFromContext((Context)this.mFragment.getActivity()));
    }

    @Override
    public void onCreateView(@Nullable View view, @Nullable Bundle savedInstanceState) {
        if (view != null) {
            this.mUnbinder = ButterKnife.bind((Object)this.mFragment, (View)view);
        }
    }

    @Override
    public void onActivityCreate(@Nullable Bundle savedInstanceState) {
        this.iFragment.initData(savedInstanceState);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
    }

    @Override
    public void onDestroyView() {
        if (this.mUnbinder != null && this.mUnbinder != Unbinder.EMPTY) {
            try {
                this.mUnbinder.unbind();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                Timber.w((String)("onDestroyView: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onDestroy() {
        if (this.iFragment != null && this.iFragment.useEventBus()) {
            EventBus.getDefault().unregister((Object)this.mFragment);
        }
        this.mUnbinder = null;
        this.mFragmentManager = null;
        this.mFragment = null;
        this.iFragment = null;
    }

    @Override
    public void onDetach() {
    }

    @Override
    public boolean isAdded() {
        return this.mFragment != null && this.mFragment.isAdded();
    }
}

