/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.style.AbsoluteSizeSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import com.jess.arms.base.App;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.integration.AppManager;
import com.jess.arms.utils.Preconditions;
import java.security.MessageDigest;

public class ArmsUtils {
    public static Toast mToast;

    private ArmsUtils() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static void setViewHintSize(Context context, int size, TextView v, int res) {
        SpannableString ss = new SpannableString((CharSequence)ArmsUtils.getResources(context).getString(res));
        AbsoluteSizeSpan ass = new AbsoluteSizeSpan(size, true);
        ss.setSpan((Object)ass, 0, ss.length(), 33);
        v.setHint((CharSequence)new SpannedString((CharSequence)ss));
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = ArmsUtils.getResources((Context)context).getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static Resources getResources(Context context) {
        return context.getResources();
    }

    public static String[] getStringArray(Context context, int id2) {
        return ArmsUtils.getResources(context).getStringArray(id2);
    }

    public static int pix2dip(Context context, int pix) {
        float densityDpi = ArmsUtils.getResources((Context)context).getDisplayMetrics().density;
        return (int)((float)pix / densityDpi + 0.5f);
    }

    public static int getDimens(Context context, int id2) {
        return (int)ArmsUtils.getResources(context).getDimension(id2);
    }

    public static float getDimens(Context context, String dimenName) {
        return ArmsUtils.getResources(context).getDimension(ArmsUtils.getResources(context).getIdentifier(dimenName, "dimen", context.getPackageName()));
    }

    public static String getString(Context context, int stringID) {
        return ArmsUtils.getResources(context).getString(stringID);
    }

    public static String getString(Context context, String strName) {
        return ArmsUtils.getString(context, ArmsUtils.getResources(context).getIdentifier(strName, "string", context.getPackageName()));
    }

    public static <T extends View> T findViewByName(Context context, View view, String viewName) {
        int id2 = ArmsUtils.getResources(context).getIdentifier(viewName, "id", context.getPackageName());
        View v = view.findViewById(id2);
        return (T)v;
    }

    public static <T extends View> T findViewByName(Context context, Activity activity, String viewName) {
        int id2 = ArmsUtils.getResources(context).getIdentifier(viewName, "id", context.getPackageName());
        View v = activity.findViewById(id2);
        return (T)v;
    }

    public static int findLayout(Context context, String layoutName) {
        int id2 = ArmsUtils.getResources(context).getIdentifier(layoutName, "layout", context.getPackageName());
        return id2;
    }

    public static View inflate(Context context, int detailScreen) {
        return View.inflate((Context)context, (int)detailScreen, null);
    }

    public static void makeText(Context context, String string) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)context, (CharSequence)string, (int)0);
        }
        mToast.setText((CharSequence)string);
        mToast.show();
    }

    public static void snackbarText(String text) {
        Message message = new Message();
        message.what = 5001;
        message.obj = text;
        message.arg1 = 0;
        AppManager.post(message);
    }

    public static void snackbarTextWithLong(String text) {
        Message message = new Message();
        message.what = 5001;
        message.obj = text;
        message.arg1 = 1;
        AppManager.post(message);
    }

    public static Drawable getDrawablebyResource(Context context, int rID) {
        return ArmsUtils.getResources(context).getDrawable(rID);
    }

    public static void startActivity(Class activityClass) {
        Message message = new Message();
        message.what = 5000;
        message.obj = activityClass;
        AppManager.post(message);
    }

    public static void startActivity(Intent content) {
        Message message = new Message();
        message.what = 5000;
        message.obj = content;
        AppManager.post(message);
    }

    public static void startActivity(Activity activity, Class homeActivityClass) {
        Intent intent = new Intent(activity.getApplicationContext(), homeActivityClass);
        activity.startActivity(intent);
    }

    public static void startActivity(Activity activity, Intent intent) {
        activity.startActivity(intent);
    }

    public static int getScreenWidth(Context context) {
        return ArmsUtils.getResources((Context)context).getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeidth(Context context) {
        return ArmsUtils.getResources((Context)context).getDisplayMetrics().heightPixels;
    }

    public static int getColor(Context context, int rid) {
        return ArmsUtils.getResources(context).getColor(rid);
    }

    public static int getColor(Context context, String colorName) {
        return ArmsUtils.getColor(context, ArmsUtils.getResources(context).getIdentifier(colorName, "color", context.getPackageName()));
    }

    public static void removeChild(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            group.removeView(view);
        }
    }

    public static boolean isEmpty(Object obj) {
        return obj == null;
    }

    public static String encodeToMD5(String string) {
        byte[] hash = new byte[]{};
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static void statuInScreen(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        attrs.flags &= 0xFFFFFBFF;
        activity.getWindow().setAttributes(attrs);
        activity.getWindow().addFlags(256);
        activity.getWindow().addFlags(512);
    }

    @Deprecated
    public static void configRecycleView(RecyclerView recyclerView, RecyclerView.LayoutManager layoutManager) {
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setHasFixedSize(true);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void configRecyclerView(RecyclerView recyclerView, RecyclerView.LayoutManager layoutManager) {
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setHasFixedSize(true);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void killAll() {
        Message message = new Message();
        message.what = 5002;
        AppManager.post(message);
    }

    public static void exitApp() {
        Message message = new Message();
        message.what = 5003;
        AppManager.post(message);
    }

    public static AppComponent obtainAppComponentFromContext(Context context) {
        Preconditions.checkNotNull(context, "%s cannot be null", Context.class.getName());
        Preconditions.checkState(context.getApplicationContext() instanceof App, "Application does not implements App");
        return ((App)context.getApplicationContext()).getAppComponent();
    }
}

