/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.integration;

import android.app.Application;
import android.content.Context;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.integration.cache.Cache;
import com.jess.arms.integration.cache.CacheType;
import com.jess.arms.utils.Preconditions;
import dagger.Lazy;
import io.rx_cache2.internal.RxCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    private Lazy<Retrofit> mRetrofit;
    private Lazy<RxCache> mRxCache;
    private Application mApplication;
    private Cache<String, Object> mRetrofitServiceCache;
    private Cache<String, Object> mCacheServiceCache;
    private Cache.Factory mCachefactory;

    @Inject
    public RepositoryManager(Lazy<Retrofit> retrofit, Lazy<RxCache> rxCache, Application application, Cache.Factory cachefactory) {
        this.mRetrofit = retrofit;
        this.mRxCache = rxCache;
        this.mApplication = application;
        this.mCachefactory = cachefactory;
    }

    @Override
    public synchronized <T> T obtainRetrofitService(Class<T> service) {
        if (this.mRetrofitServiceCache == null) {
            this.mRetrofitServiceCache = this.mCachefactory.build(CacheType.RETROFIT_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mRetrofitServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Object retrofitService = this.mRetrofitServiceCache.get(service.getCanonicalName());
        if (retrofitService == null) {
            retrofitService = ((Retrofit)this.mRetrofit.get()).create(service);
            this.mRetrofitServiceCache.put(service.getCanonicalName(), retrofitService);
        }
        return (T)retrofitService;
    }

    @Override
    public synchronized <T> T obtainCacheService(Class<T> cache) {
        if (this.mCacheServiceCache == null) {
            this.mCacheServiceCache = this.mCachefactory.build(CacheType.CACHE_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mCacheServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Object cacheService = this.mCacheServiceCache.get(cache.getCanonicalName());
        if (cacheService == null) {
            cacheService = ((RxCache)this.mRxCache.get()).using(cache);
            this.mCacheServiceCache.put(cache.getCanonicalName(), cacheService);
        }
        return (T)cacheService;
    }

    @Override
    public void clearAllCache() {
        ((RxCache)this.mRxCache.get()).evictAll();
    }

    @Override
    public Context getContext() {
        return this.mApplication;
    }
}

