/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.integration;

import android.app.Application;
import android.content.Context;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.integration.cache.Cache;
import com.jess.arms.integration.cache.CacheType;
import com.jess.arms.utils.Preconditions;
import dagger.Lazy;
import io.rx_cache2.internal.RxCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    private Lazy<Retrofit> mRetrofit;
    private Lazy<RxCache> mRxCache;
    private Application mApplication;
    private Cache<String, Object> mRetrofitServiceCache;
    private Cache<String, Object> mCacheServiceCache;
    private Cache.Factory mCachefactory;

    @Inject
    public RepositoryManager(Lazy<Retrofit> retrofit, Lazy<RxCache> rxCache, Application application, Cache.Factory cachefactory) {
        this.mRetrofit = retrofit;
        this.mRxCache = rxCache;
        this.mApplication = application;
        this.mCachefactory = cachefactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T obtainRetrofitService(Class<T> service) {
        Object retrofitService;
        if (this.mRetrofitServiceCache == null) {
            this.mRetrofitServiceCache = this.mCachefactory.build(CacheType.RETROFIT_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mRetrofitServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, Object> cache = this.mRetrofitServiceCache;
        synchronized (cache) {
            retrofitService = this.mRetrofitServiceCache.get(service.getName());
            if (retrofitService == null) {
                retrofitService = ((Retrofit)this.mRetrofit.get()).create(service);
                this.mRetrofitServiceCache.put(service.getName(), retrofitService);
            }
        }
        return (T)retrofitService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T obtainCacheService(Class<T> cache) {
        Object cacheService;
        if (this.mCacheServiceCache == null) {
            this.mCacheServiceCache = this.mCachefactory.build(CacheType.CACHE_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mCacheServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, Object> cache2 = this.mCacheServiceCache;
        synchronized (cache2) {
            cacheService = this.mCacheServiceCache.get(cache.getName());
            if (cacheService == null) {
                cacheService = ((RxCache)this.mRxCache.get()).using(cache);
                this.mCacheServiceCache.put(cache.getName(), cacheService);
            }
        }
        return (T)cacheService;
    }

    @Override
    public void clearAllCache() {
        ((RxCache)this.mRxCache.get()).evictAll();
    }

    @Override
    public Context getContext() {
        return this.mApplication;
    }
}

