/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.http.imageloader.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.jess.arms.http.imageloader.BaseImageLoaderStrategy;
import com.jess.arms.http.imageloader.glide.GlideAppliesOptions;
import com.jess.arms.http.imageloader.glide.GlideArms;
import com.jess.arms.http.imageloader.glide.GlideRequest;
import com.jess.arms.http.imageloader.glide.GlideRequests;
import com.jess.arms.http.imageloader.glide.ImageConfigImpl;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import timber.log.Timber;

public class GlideImageLoaderStrategy
implements BaseImageLoaderStrategy<ImageConfigImpl>,
GlideAppliesOptions {
    @Override
    public void loadImage(Context ctx, ImageConfigImpl config) {
        if (ctx == null) {
            throw new NullPointerException("Context is required");
        }
        if (config == null) {
            throw new NullPointerException("ImageConfigImpl is required");
        }
        if (TextUtils.isEmpty((CharSequence)config.getUrl())) {
            throw new NullPointerException("Url is required");
        }
        if (config.getImageView() == null) {
            throw new NullPointerException("Imageview is required");
        }
        GlideRequests requests = GlideArms.with(ctx);
        GlideRequest glideRequest = requests.load(config.getUrl()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).centerCrop();
        switch (config.getCacheStrategy()) {
            case 0: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.ALL);
                break;
            }
            case 1: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.NONE);
                break;
            }
            case 2: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.RESOURCE);
                break;
            }
            case 3: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.DATA);
                break;
            }
            case 4: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
            }
        }
        if (config.getTransformation() != null) {
            glideRequest.transform((Transformation<Bitmap>)config.getTransformation());
        }
        if (config.getPlaceholder() != 0) {
            glideRequest.placeholder(config.getPlaceholder());
        }
        if (config.getErrorPic() != 0) {
            glideRequest.error(config.getErrorPic());
        }
        if (config.getFallback() != 0) {
            glideRequest.fallback(config.getFallback());
        }
        glideRequest.into(config.getImageView());
    }

    @Override
    public void clear(final Context ctx, ImageConfigImpl config) {
        if (ctx == null) {
            throw new NullPointerException("Context is required");
        }
        if (config == null) {
            throw new NullPointerException("ImageConfigImpl is required");
        }
        if (config.getImageViews() != null && config.getImageViews().length > 0) {
            for (ImageView imageView : config.getImageViews()) {
                GlideArms.get(ctx).getRequestManagerRetriever().get(ctx).clear((View)imageView);
            }
        }
        if (config.isClearDiskCache()) {
            Observable.just((Object)0).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<Integer>(){

                public void accept(@NonNull Integer integer) throws Exception {
                    Glide.get((Context)ctx).clearDiskCache();
                }
            });
        }
        if (config.isClearMemory()) {
            Observable.just((Object)0).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Integer>(){

                public void accept(@NonNull Integer integer) throws Exception {
                    Glide.get((Context)ctx).clearMemory();
                }
            });
        }
    }

    @Override
    public void applyGlideOptions(Context context, GlideBuilder builder) {
        Timber.w((String)"applyGlideOptions", (Object[])new Object[0]);
    }
}

