/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.jess.arms.base.delegate.IActivity;
import com.jess.arms.integration.lifecycle.ActivityLifecycleable;
import com.jess.arms.mvp.IPresenter;
import com.jess.arms.utils.ThirdViewUtil;
import com.trello.rxlifecycle2.android.ActivityEvent;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import javax.inject.Inject;

public abstract class BaseActivity<P extends IPresenter>
extends AppCompatActivity
implements IActivity,
ActivityLifecycleable {
    protected final String TAG = this.getClass().getSimpleName();
    private Unbinder mUnbinder;
    private final BehaviorSubject<ActivityEvent> mLifecycleSubject = BehaviorSubject.create();
    @Inject
    protected P mPresenter;

    @Override
    @NonNull
    public final Subject<ActivityEvent> provideLifecycleSubject() {
        return this.mLifecycleSubject;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        View view = ThirdViewUtil.convertAutoView(name, context, attrs);
        return view == null ? super.onCreateView(name, context, attrs) : view;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            int layoutResID = this.initView(savedInstanceState);
            if (layoutResID != 0) {
                this.setContentView(layoutResID);
                this.mUnbinder = ButterKnife.bind((Activity)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initData(savedInstanceState);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mUnbinder != null && this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
        this.mUnbinder = null;
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
        this.mPresenter = null;
    }

    @Override
    public boolean useEventBus() {
        return true;
    }

    @Override
    public boolean useFragment() {
        return true;
    }
}

