/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import com.tbruyelle.rxpermissions2.Permission;
import com.tbruyelle.rxpermissions2.RxPermissions;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import timber.log.Timber;

public class PermissionUtil {
    public static final String TAG = "Permission";

    private PermissionUtil() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static void requestPermission(final RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return;
        }
        ArrayList<String> needRequest = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (rxPermissions.isGranted(permission2)) continue;
            needRequest.add(permission2);
        }
        if (needRequest.isEmpty()) {
            requestPermission.onRequestPermissionSuccess();
        } else {
            rxPermissions.requestEach(needRequest.toArray(new String[needRequest.size()])).buffer(permissions.length).subscribe((Observer)new ErrorHandleSubscriber<List<Permission>>(errorHandler){

                public void onNext(@NonNull List<Permission> permissions) {
                    for (Permission p : permissions) {
                        if (p.granted) continue;
                        if (p.shouldShowRequestPermissionRationale) {
                            Timber.tag((String)PermissionUtil.TAG).d("Request permissions failure", new Object[0]);
                            requestPermission.onRequestPermissionFailure(Arrays.asList(p.name));
                            return;
                        }
                        Timber.tag((String)PermissionUtil.TAG).d("Request permissions failure with ask never again", new Object[0]);
                        requestPermission.onRequestPermissionFailureWithAskNeverAgain(Arrays.asList(p.name));
                        return;
                    }
                    Timber.tag((String)PermissionUtil.TAG).d("Request permissions success", new Object[0]);
                    requestPermission.onRequestPermissionSuccess();
                }
            });
        }
    }

    public static void launchCamera(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA");
    }

    public static void externalStorage(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static void sendSms(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.SEND_SMS");
    }

    public static void callPhone(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.CALL_PHONE");
    }

    public static void readPhonestate(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.READ_PHONE_STATE");
    }

    public static interface RequestPermission {
        public void onRequestPermissionSuccess();

        public void onRequestPermissionFailure(List<String> var1);

        public void onRequestPermissionFailureWithAskNeverAgain(List<String> var1);
    }
}

