/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.integration.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.jess.arms.integration.lifecycle.ActivityLifecycleable;
import com.jess.arms.integration.lifecycle.FragmentLifecycleForRxLifecycle;
import com.trello.rxlifecycle2.android.ActivityEvent;
import io.reactivex.subjects.Subject;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ActivityLifecycleForRxLifecycle
implements Application.ActivityLifecycleCallbacks {
    private FragmentManager.FragmentLifecycleCallbacks mFragmentLifecycle;

    @Inject
    public ActivityLifecycleForRxLifecycle() {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (activity instanceof ActivityLifecycleable) {
            this.obtainSubject(activity).onNext((Object)ActivityEvent.CREATE);
            if (activity instanceof FragmentActivity) {
                if (this.mFragmentLifecycle == null) {
                    this.mFragmentLifecycle = new FragmentLifecycleForRxLifecycle();
                }
                ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(this.mFragmentLifecycle, true);
            }
        }
    }

    public void onActivityStarted(Activity activity) {
        if (activity instanceof ActivityLifecycleable) {
            this.obtainSubject(activity).onNext((Object)ActivityEvent.START);
        }
    }

    public void onActivityResumed(Activity activity) {
        if (activity instanceof ActivityLifecycleable) {
            this.obtainSubject(activity).onNext((Object)ActivityEvent.RESUME);
        }
    }

    public void onActivityPaused(Activity activity) {
        if (activity instanceof ActivityLifecycleable) {
            this.obtainSubject(activity).onNext((Object)ActivityEvent.PAUSE);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (activity instanceof ActivityLifecycleable) {
            this.obtainSubject(activity).onNext((Object)ActivityEvent.STOP);
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (activity instanceof ActivityLifecycleable) {
            this.obtainSubject(activity).onNext((Object)ActivityEvent.DESTROY);
        }
    }

    private Subject<ActivityEvent> obtainSubject(Activity activity) {
        return ((ActivityLifecycleable)activity).provideLifecycleSubject();
    }
}

