/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.media.ExifInterface;
import android.widget.TextView;
import java.io.IOException;

public class DrawableProvider {
    private DrawableProvider() {
    }

    public static Drawable getStateListDrawable(Drawable normalDrawable, Drawable pressDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{0x10100A0}, pressDrawable);
        stateListDrawable.addState(new int[0], normalDrawable);
        return stateListDrawable;
    }

    public static Drawable getScaleDrawableForRadioButton(float percent, TextView rb) {
        Drawable[] compoundDrawables = rb.getCompoundDrawables();
        Drawable drawable = null;
        for (Drawable d : compoundDrawables) {
            if (d == null) continue;
            drawable = d;
        }
        drawable.setBounds(0, 0, (int)((float)drawable.getIntrinsicWidth() * percent + 0.5f), (int)((float)drawable.getIntrinsicHeight() * percent + 0.5f));
        return drawable;
    }

    public static Drawable getScaleDrawableForRadioButton2(float width, TextView rb) {
        Drawable[] compoundDrawables = rb.getCompoundDrawables();
        Drawable drawable = null;
        for (Drawable d : compoundDrawables) {
            if (d == null) continue;
            drawable = d;
        }
        float percent = width * 1.0f / (float)drawable.getIntrinsicWidth();
        drawable.setBounds(0, 0, (int)((float)drawable.getIntrinsicWidth() * percent + 0.5f), (int)((float)drawable.getIntrinsicHeight() * percent + 0.5f));
        return drawable;
    }

    public static Drawable getScaleDrawable(float percent, Drawable drawable) {
        drawable.setBounds(0, 0, (int)((float)drawable.getIntrinsicWidth() * percent + 0.5f), (int)((float)drawable.getIntrinsicHeight() * percent + 0.5f));
        return drawable;
    }

    public static Drawable getScaleDrawable2(float width, Drawable drawable) {
        float percent = width * 1.0f / (float)drawable.getIntrinsicWidth();
        drawable.setBounds(0, 0, (int)((float)drawable.getIntrinsicWidth() * percent + 0.5f), (int)((float)drawable.getIntrinsicHeight() * percent + 0.5f));
        return drawable;
    }

    public static void setLeftDrawable(TextView tv, Drawable drawable) {
        tv.setCompoundDrawables(drawable, null, null, null);
    }

    public static Bitmap getReSizeBitmap(Bitmap bitmap, float targetWidth, float targetheight) {
        Bitmap returnBm = null;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(targetWidth / (float)width, targetheight / (float)height);
        try {
            returnBm = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (returnBm == null) {
            returnBm = bitmap;
        }
        if (bitmap != returnBm) {
            bitmap.recycle();
        }
        return returnBm;
    }

    public static Bitmap rotateBitmapByDegree(Bitmap bm, int degree) {
        Bitmap returnBm = null;
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        try {
            returnBm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        if (returnBm == null) {
            returnBm = bm;
        }
        if (bm != returnBm) {
            bm.recycle();
        }
        return returnBm;
    }

    public static int getBitmapDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }
}

