/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.integration;

import android.app.Application;
import android.content.Context;
import com.jess.arms.integration.IRepositoryManager;
import dagger.Lazy;
import io.rx_cache2.internal.RxCache;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    private Lazy<Retrofit> mRetrofit;
    private Lazy<RxCache> mRxCache;
    private Application mApplication;
    private final Map<String, Object> mRetrofitServiceCache = new HashMap<String, Object>();
    private final Map<String, Object> mCacheServiceCache = new HashMap<String, Object>();

    @Inject
    public RepositoryManager(Lazy<Retrofit> retrofit, Lazy<RxCache> rxCache, Application application) {
        this.mRetrofit = retrofit;
        this.mRxCache = rxCache;
        this.mApplication = application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T obtainRetrofitService(Class<T> service) {
        Object retrofitService;
        Map<String, Object> map = this.mRetrofitServiceCache;
        synchronized (map) {
            retrofitService = this.mRetrofitServiceCache.get(service.getName());
            if (retrofitService == null) {
                retrofitService = ((Retrofit)this.mRetrofit.get()).create(service);
                this.mRetrofitServiceCache.put(service.getName(), retrofitService);
            }
        }
        return (T)retrofitService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T obtainCacheService(Class<T> cache) {
        Object cacheService;
        Map<String, Object> map = this.mCacheServiceCache;
        synchronized (map) {
            cacheService = this.mCacheServiceCache.get(cache.getName());
            if (cacheService == null) {
                cacheService = ((RxCache)this.mRxCache.get()).using(cache);
                this.mCacheServiceCache.put(cache.getName(), cacheService);
            }
        }
        return (T)cacheService;
    }

    @Override
    public void clearAllCache() {
        ((RxCache)this.mRxCache.get()).evictAll();
    }

    @Override
    public Context getContext() {
        return this.mApplication;
    }
}

