/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.style.AbsoluteSizeSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import java.security.MessageDigest;
import org.simple.eventbus.EventBus;

public class UiUtils {
    public static Toast mToast;

    private UiUtils() {
    }

    public static void setViewHintSize(Context context, int size, TextView v, int res) {
        SpannableString ss = new SpannableString((CharSequence)UiUtils.getResources(context).getString(res));
        AbsoluteSizeSpan ass = new AbsoluteSizeSpan(size, true);
        ss.setSpan((Object)ass, 0, ss.length(), 33);
        v.setHint((CharSequence)new SpannedString((CharSequence)ss));
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = UiUtils.getResources((Context)context).getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static Resources getResources(Context context) {
        return context.getResources();
    }

    public static String[] getStringArray(Context context, int id2) {
        return UiUtils.getResources(context).getStringArray(id2);
    }

    public static int pix2dip(Context context, int pix) {
        float densityDpi = UiUtils.getResources((Context)context).getDisplayMetrics().density;
        return (int)((float)pix / densityDpi + 0.5f);
    }

    public static int getDimens(Context context, int homePicHeight) {
        return (int)UiUtils.getResources(context).getDimension(homePicHeight);
    }

    public static float getDimens(Context context, String dimenNmae) {
        return UiUtils.getResources(context).getDimension(UiUtils.getResources(context).getIdentifier(dimenNmae, "dimen", context.getPackageName()));
    }

    public static String getString(Context context, int stringID) {
        return UiUtils.getResources(context).getString(stringID);
    }

    public static String getString(Context context, String strName) {
        return UiUtils.getString(context, UiUtils.getResources(context).getIdentifier(strName, "string", context.getPackageName()));
    }

    public static <T extends View> T findViewByName(Context context, View view, String viewName) {
        int id2 = UiUtils.getResources(context).getIdentifier(viewName, "id", context.getPackageName());
        View v = view.findViewById(id2);
        return (T)v;
    }

    public static <T extends View> T findViewByName(Context context, Activity activity, String viewName) {
        int id2 = UiUtils.getResources(context).getIdentifier(viewName, "id", context.getPackageName());
        View v = activity.findViewById(id2);
        return (T)v;
    }

    public static int findLayout(Context context, String layoutName) {
        int id2 = UiUtils.getResources(context).getIdentifier(layoutName, "layout", context.getPackageName());
        return id2;
    }

    public static View inflate(Context context, int detailScreen) {
        return View.inflate((Context)context, (int)detailScreen, null);
    }

    public static void makeText(Context context, String string) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)context, (CharSequence)string, (int)0);
        }
        mToast.setText((CharSequence)string);
        mToast.show();
    }

    public static void snackbarText(String text) {
        Message message = new Message();
        message.what = 1;
        message.obj = text;
        message.arg1 = 0;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void snackbarTextWithLong(String text) {
        Message message = new Message();
        message.what = 1;
        message.obj = text;
        message.arg1 = 1;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static Drawable getDrawablebyResource(Context context, int rID) {
        return UiUtils.getResources(context).getDrawable(rID);
    }

    public static void startActivity(Activity activity, Class homeActivityClass) {
        Intent intent = new Intent(activity.getApplicationContext(), homeActivityClass);
        activity.startActivity(intent);
    }

    public static void startActivity(Class homeActivityClass) {
        Message message = new Message();
        message.what = 0;
        message.obj = homeActivityClass;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void startActivity(Intent content) {
        Message message = new Message();
        message.what = 0;
        message.obj = content;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void startActivity(Activity activity, Intent intent) {
        activity.startActivity(intent);
    }

    public static int getLayoutId(Context context, String layoutName) {
        return UiUtils.getResources(context).getIdentifier(layoutName, "layout", context.getPackageName());
    }

    public static int getScreenWidth(Context context) {
        return UiUtils.getResources((Context)context).getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeidth(Context context) {
        return UiUtils.getResources((Context)context).getDisplayMetrics().heightPixels;
    }

    public static int getColor(Context context, int rid) {
        return UiUtils.getResources(context).getColor(rid);
    }

    public static int getColor(Context context, String colorName) {
        return UiUtils.getColor(context, UiUtils.getResources(context).getIdentifier(colorName, "color", context.getPackageName()));
    }

    public static void removeChild(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            group.removeView(view);
        }
    }

    public static boolean isEmpty(Object obj) {
        return obj == null;
    }

    public static String encodeToMD5(String string) {
        byte[] hash = new byte[]{};
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static void statuInScreen(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        attrs.flags &= 0xFFFFFBFF;
        activity.getWindow().setAttributes(attrs);
        activity.getWindow().addFlags(256);
        activity.getWindow().addFlags(512);
    }

    public static void configRecycleView(RecyclerView recyclerView, RecyclerView.LayoutManager layoutManager) {
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setHasFixedSize(true);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void killAll() {
        Message message = new Message();
        message.what = 2;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void exitApp() {
        Message message = new Message();
        message.what = 3;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }
}

