/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import java.io.File;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.List;

@TargetApi(value=14)
public class DeviceUtils {
    public static final int NETTYPE_WIFI = 1;
    public static final int NETTYPE_CMWAP = 2;
    public static final int NETTYPE_CMNET = 3;
    public static boolean GTE_HC;
    public static boolean GTE_ICS;
    public static boolean PRE_HC;
    private static Boolean _hasBigScreen;
    private static Boolean _hasCamera;
    private static Boolean _isTablet;
    private static Integer _loadFactor;
    public static float displayDensity;

    private DeviceUtils() {
    }

    public static float dpToPixel(Context context, float dp) {
        return dp * ((float)DeviceUtils.getDisplayMetrics((Context)context).densityDpi / 160.0f);
    }

    public static float pixelsToDp(Context context, float f) {
        return f / ((float)DeviceUtils.getDisplayMetrics((Context)context).densityDpi / 160.0f);
    }

    public static int getDefaultLoadFactor(Context context) {
        if (_loadFactor == null) {
            Integer integer;
            _loadFactor = integer = Integer.valueOf(0xF & context.getResources().getConfiguration().screenLayout);
            _loadFactor = Math.max(integer, 1);
        }
        return _loadFactor;
    }

    public static float getDensity(Context context) {
        if ((double)displayDensity == 0.0) {
            displayDensity = DeviceUtils.getDisplayMetrics((Context)context).density;
        }
        return displayDensity;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displaymetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displaymetrics);
        return displaymetrics;
    }

    public static float getScreenHeight(Context context) {
        return DeviceUtils.getDisplayMetrics((Context)context).heightPixels;
    }

    public static float getScreenWidth(Context context) {
        return DeviceUtils.getDisplayMetrics((Context)context).widthPixels;
    }

    public static int[] getRealScreenSize(Activity activity) {
        int[] size = new int[2];
        int screenWidth = 0;
        int screenHeight = 0;
        WindowManager w = activity.getWindowManager();
        Display d = w.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        screenWidth = metrics.widthPixels;
        screenHeight = metrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                screenWidth = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
                screenHeight = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)d, realSize);
                screenWidth = realSize.x;
                screenHeight = realSize.y;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        size[0] = screenWidth;
        size[1] = screenHeight;
        return size;
    }

    public static int getStatusBarHeight(Context context) {
        Class<?> c = null;
        Object obj = null;
        Field field = null;
        int x = 0;
        try {
            c = Class.forName("com.android.internal.R$dimen");
            obj = c.newInstance();
            field = c.getField("status_bar_height");
            x = Integer.parseInt(field.get(obj).toString());
            return context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean hasBigScreen(Context context) {
        boolean flag = true;
        if (_hasBigScreen == null) {
            Boolean boolean1;
            boolean flag1 = (0xF & context.getResources().getConfiguration().screenLayout) >= 3 ? flag : false;
            _hasBigScreen = boolean1 = Boolean.valueOf(flag1);
            if (!boolean1.booleanValue()) {
                if (DeviceUtils.getDensity(context) <= 1.5f) {
                    flag = false;
                }
                _hasBigScreen = flag;
            }
        }
        return _hasBigScreen;
    }

    public static final boolean hasCamera(Context context) {
        if (_hasCamera == null) {
            PackageManager pckMgr = context.getPackageManager();
            boolean flag = pckMgr.hasSystemFeature("android.hardware.camera.front");
            boolean flag1 = pckMgr.hasSystemFeature("android.hardware.camera");
            boolean flag2 = flag || flag1;
            _hasCamera = flag2;
        }
        return _hasCamera;
    }

    public static boolean hasHardwareMenuKey(Context context) {
        boolean flag = false;
        flag = PRE_HC ? true : (GTE_ICS ? ViewConfiguration.get((Context)context).hasPermanentMenuKey() : false);
        return flag;
    }

    public static boolean hasInternet(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        boolean flag = manager != null && manager.getActiveNetworkInfo() != null;
        return flag;
    }

    public static boolean isPackageExist(Context context, String pckName) {
        try {
            PackageInfo pckInfo = context.getPackageManager().getPackageInfo(pckName, 0);
            if (pckInfo != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"TDvice", (String)e.getMessage());
        }
        return false;
    }

    public static void hideAnimatedView(View view) {
        if (PRE_HC && view != null) {
            view.setPadding(view.getWidth(), 0, 0, 0);
        }
    }

    public static void hideSoftKeyboard(Context context, View view) {
        if (view == null) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        if (inputMethodManager.isActive()) {
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static boolean isLandscape(Context context) {
        boolean flag = context.getResources().getConfiguration().orientation == 2;
        return flag;
    }

    public static boolean isPortrait(Context context) {
        boolean flag = true;
        if (context.getResources().getConfiguration().orientation != 1) {
            flag = false;
        }
        return flag;
    }

    public static boolean isTablet(Context context) {
        if (_isTablet == null) {
            boolean flag = (0xF & context.getResources().getConfiguration().screenLayout) >= 3;
            _isTablet = flag;
        }
        return _isTablet;
    }

    public static void showAnimatedView(View view) {
        if (PRE_HC && view != null) {
            view.setPadding(0, 0, 0, 0);
        }
    }

    public static void showSoftKeyboard(Dialog dialog) {
        dialog.getWindow().setSoftInputMode(4);
    }

    public static void showSoftKeyboard(Context context, View view) {
        ((InputMethodManager)context.getSystemService("input_method")).showSoftInput(view, 2);
    }

    public static void toogleSoftKeyboard(Context context, View view) {
        ((InputMethodManager)context.getSystemService("input_method")).toggleSoftInput(0, 2);
    }

    public static boolean isSdcardReady() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String getCurCountryLan(Context context) {
        return context.getResources().getConfiguration().locale.getLanguage() + "-" + context.getResources().getConfiguration().locale.getCountry();
    }

    public static boolean isZhCN(Context context) {
        String lang = context.getResources().getConfiguration().locale.getCountry();
        return lang.equalsIgnoreCase("CN");
    }

    public static String percent(double p1, double p2) {
        double p3 = p1 / p2;
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        String str = nf.format(p3);
        return str;
    }

    public static String percent2(double p1, double p2) {
        double p3 = p1 / p2;
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(0);
        String str = nf.format(p3);
        return str;
    }

    public static boolean isHaveMarket(Context context) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.APP_MARKET");
        PackageManager pm = context.getPackageManager();
        List infos = pm.queryIntentActivities(intent, 0);
        return infos.size() > 0;
    }

    public static void setFullScreen(Activity activity) {
        WindowManager.LayoutParams params = activity.getWindow().getAttributes();
        params.flags |= 0x400;
        activity.getWindow().setAttributes(params);
        activity.getWindow().addFlags(512);
    }

    public static void cancelFullScreen(Activity activity) {
        WindowManager.LayoutParams params = activity.getWindow().getAttributes();
        params.flags &= 0xFFFFFBFF;
        activity.getWindow().setAttributes(params);
        activity.getWindow().clearFlags(512);
    }

    public static PackageInfo getPackageInfo(Context context, String pckName) {
        try {
            return context.getPackageManager().getPackageInfo(pckName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getVersionCode(Context context) {
        int versionCode = 0;
        try {
            versionCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException ex) {
            versionCode = 0;
        }
        return versionCode;
    }

    public static int getVersionCode(Context context, String packageName) {
        int versionCode = 0;
        try {
            versionCode = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException ex) {
            versionCode = 0;
        }
        return versionCode;
    }

    public static String getVersionName(Context context) {
        String name = "";
        try {
            name = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException ex) {
            name = "";
        }
        return name;
    }

    public static boolean isScreenOn(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        return pm.isScreenOn();
    }

    public static void installAPK(Context context, File file) {
        if (file == null || !file.exists()) {
            return;
        }
        Intent intent = new Intent();
        intent.setFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    public static Intent getInstallApkIntent(File file) {
        Intent intent = new Intent();
        intent.setFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        return intent;
    }

    public static void openDial(Context context, String number) {
        Uri uri = Uri.parse((String)("tel:" + number));
        Intent it = new Intent("android.intent.action.DIAL", uri);
        context.startActivity(it);
    }

    public static void openSMS(Context context, String smsBody, String tel) {
        Uri uri = Uri.parse((String)("smsto:" + tel));
        Intent it = new Intent("android.intent.action.SENDTO", uri);
        it.putExtra("sms_body", smsBody);
        context.startActivity(it);
    }

    public static void openDail(Context context) {
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void openSendMsg(Context context) {
        Uri uri = Uri.parse((String)"smsto:");
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void openCamera(Context context) {
        Intent intent = new Intent();
        intent.setAction("android.media.action.STILL_IMAGE_CAMERA");
        intent.setFlags(885260288);
        context.startActivity(intent);
    }

    public static String getIMEI(Context context) {
        TelephonyManager tel = (TelephonyManager)context.getSystemService("phone");
        return tel.getDeviceId();
    }

    public static String getPhoneType() {
        return Build.MODEL;
    }

    public static void openApp(Context context, String packageName) {
        Intent mainIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (mainIntent == null) {
            mainIntent = new Intent(packageName);
        }
        context.startActivity(mainIntent);
    }

    public static boolean openAppActivity(Context context, String packageName, String activityName) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        ComponentName cn = new ComponentName(packageName, activityName);
        intent.setComponent(cn);
        try {
            context.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWifiOpen(Context context) {
        boolean isWifiConnect = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo[] networkInfos = cm.getAllNetworkInfo();
        for (int i = 0; i < networkInfos.length; ++i) {
            if (networkInfos[i].getState() != NetworkInfo.State.CONNECTED) continue;
            if (networkInfos[i].getType() == 0) {
                isWifiConnect = false;
            }
            if (networkInfos[i].getType() != 1) continue;
            isWifiConnect = true;
        }
        return isWifiConnect;
    }

    public static void uninstallApk(Context context, String packageName) {
        if (DeviceUtils.isPackageExist(context, packageName)) {
            Uri packageURI = Uri.parse((String)("package:" + packageName));
            Intent uninstallIntent = new Intent("android.intent.action.DELETE", packageURI);
            context.startActivity(uninstallIntent);
        }
    }

    public static void copyTextToBoard(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        ClipboardManager clip = (ClipboardManager)context.getSystemService("clipboard");
        clip.setText((CharSequence)string);
    }

    public static void sendEmail(Context context, String subject, String content, String ... emails) {
        try {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("message/rfc822");
            intent.putExtra("android.intent.extra.EMAIL", emails);
            intent.putExtra("android.intent.extra.SUBJECT", subject);
            intent.putExtra("android.intent.extra.TEXT", content);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static int getStatuBarHeight(Context context) {
        Class<?> c = null;
        Object obj = null;
        Field field = null;
        int x = 0;
        int sbar = 38;
        try {
            c = Class.forName("com.android.internal.R$dimen");
            obj = c.newInstance();
            field = c.getField("status_bar_height");
            x = Integer.parseInt(field.get(obj).toString());
            sbar = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return sbar;
    }

    public static boolean hasStatusBar(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        return (attrs.flags & 0x400) != 1024;
    }

    public static void showSystemShareOption(Activity context, String title, String url) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", "\u5206\u4eab\uff1a" + title);
        intent.putExtra("android.intent.extra.TEXT", title + " " + url);
        context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u9009\u62e9\u5206\u4eab"));
    }

    public static int getNetworkType(Context context) {
        int netType = 0;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        int nType = networkInfo.getType();
        if (nType == 0) {
            String extraInfo = networkInfo.getExtraInfo();
            if (extraInfo != null && !extraInfo.isEmpty()) {
                netType = extraInfo.equalsIgnoreCase("cmnet") ? 3 : 2;
            }
        } else if (nType == 1) {
            netType = 1;
        }
        return netType;
    }

    public static boolean netIsConnected(Context context) {
        ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mobNetInfo = connectMgr.getNetworkInfo(0);
        NetworkInfo wifiNetInfo = connectMgr.getNetworkInfo(1);
        return mobNetInfo.isConnected() || wifiNetInfo.isConnected();
    }

    public static boolean isExitsSdcard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    static {
        _hasBigScreen = null;
        _hasCamera = null;
        _isTablet = null;
        _loadFactor = null;
        displayDensity = 0.0f;
        GTE_ICS = Build.VERSION.SDK_INT >= 14;
        GTE_HC = Build.VERSION.SDK_INT >= 11;
        PRE_HC = Build.VERSION.SDK_INT < 11;
    }
}

