/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.http;

import android.support.annotation.Nullable;
import com.jess.arms.http.GlobalHttpHandler;
import com.jess.arms.utils.CharactorHandler;
import com.jess.arms.utils.ZipHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import timber.log.Timber;

@Singleton
public class RequestInterceptor
implements Interceptor {
    private GlobalHttpHandler mHandler;

    @Inject
    public RequestInterceptor(@Nullable GlobalHttpHandler handler) {
        this.mHandler = handler;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response originalResponse;
        Request request = chain.request();
        boolean hasRequestBody = request.body() != null;
        Timber.tag((String)this.getTag(request, "Request_Info")).w("Params : \u300c %s \u300d%nConnection : \u300c %s \u300d%nHeaders : %n\u300c %s \u300d", new Object[]{hasRequestBody ? RequestInterceptor.parseParams(request.newBuilder().build().body()) : "Null", chain.connection(), request.headers()});
        long t1 = System.nanoTime();
        try {
            originalResponse = chain.proceed(request);
        }
        catch (Exception e) {
            Timber.w((String)("Http Error: " + e), (Object[])new Object[0]);
            throw e;
        }
        long t2 = System.nanoTime();
        String bodySize = originalResponse.body().contentLength() != -1L ? originalResponse.body().contentLength() + "-byte" : "unknown-length";
        Timber.tag((String)this.getTag(request, "Response_Info")).w("Received response in [ %d-ms ] , [ %s ]%n%s", new Object[]{TimeUnit.NANOSECONDS.toMillis(t2 - t1), bodySize, originalResponse.headers()});
        String bodyString = this.printResult(request, originalResponse);
        if (this.mHandler != null) {
            return this.mHandler.onHttpResultResponse(bodyString, chain, originalResponse);
        }
        return originalResponse;
    }

    @Nullable
    private String printResult(Request request, Response originalResponse) throws IOException {
        ResponseBody responseBody = originalResponse.body();
        String bodyString = null;
        if (RequestInterceptor.isParseable(responseBody.contentType())) {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            String encoding = originalResponse.headers().get("Content-Encoding");
            Buffer clone = buffer.clone();
            bodyString = this.parseContent(responseBody, encoding, clone);
            Timber.tag((String)this.getTag(request, "Response_Result")).w(RequestInterceptor.isJson(responseBody.contentType()) ? CharactorHandler.jsonFormat(bodyString) : bodyString, new Object[0]);
        } else {
            Timber.tag((String)this.getTag(request, "Response_Result")).w("This result isn't parsed", new Object[0]);
        }
        return bodyString;
    }

    private String getTag(Request request, String tag) {
        return String.format(" [%s] \u300c %s \u300d>>> %s", request.method(), request.url().toString(), tag);
    }

    private String parseContent(ResponseBody responseBody, String encoding, Buffer clone) {
        Charset charset = Charset.forName("UTF-8");
        MediaType contentType = responseBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            return ZipHelper.decompressForGzip(clone.readByteArray(), RequestInterceptor.convertCharset(charset));
        }
        if (encoding != null && encoding.equalsIgnoreCase("zlib")) {
            return ZipHelper.decompressToStringForZlib(clone.readByteArray(), RequestInterceptor.convertCharset(charset));
        }
        return clone.readString(charset);
    }

    public static String parseParams(RequestBody body) throws UnsupportedEncodingException {
        if (RequestInterceptor.isParseable(body.contentType())) {
            try {
                Buffer requestbuffer = new Buffer();
                body.writeTo((BufferedSink)requestbuffer);
                Charset charset = Charset.forName("UTF-8");
                MediaType contentType = body.contentType();
                if (contentType != null) {
                    charset = contentType.charset(charset);
                }
                return URLDecoder.decode(requestbuffer.readString(charset), RequestInterceptor.convertCharset(charset));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "This params isn't parsed";
    }

    public static boolean isParseable(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return mediaType.toString().toLowerCase().contains("text") || RequestInterceptor.isJson(mediaType) || RequestInterceptor.isForm(mediaType) || RequestInterceptor.isHtml(mediaType) || RequestInterceptor.isXml(mediaType);
    }

    public static boolean isJson(MediaType mediaType) {
        return mediaType.toString().toLowerCase().contains("json");
    }

    public static boolean isXml(MediaType mediaType) {
        return mediaType.toString().toLowerCase().contains("xml");
    }

    public static boolean isHtml(MediaType mediaType) {
        return mediaType.toString().toLowerCase().contains("html");
    }

    public static boolean isForm(MediaType mediaType) {
        return mediaType.toString().toLowerCase().contains("x-www-form-urlencoded");
    }

    public static String convertCharset(Charset charset) {
        String s = charset.toString();
        int i = s.indexOf("[");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1, s.length() - 1);
    }
}

