/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base.delegate;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import com.jess.arms.base.App;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.di.component.DaggerAppComponent;
import com.jess.arms.di.module.AppModule;
import com.jess.arms.di.module.ClientModule;
import com.jess.arms.di.module.GlobalConfigModule;
import com.jess.arms.integration.ActivityLifecycle;
import com.jess.arms.integration.ConfigModule;
import com.jess.arms.integration.ManifestParser;
import com.jess.arms.widget.imageloader.glide.GlideImageConfig;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class AppDelegate
implements App {
    private Application mApplication;
    private AppComponent mAppComponent;
    @Inject
    protected ActivityLifecycle mActivityLifecycle;
    private final List<ConfigModule> mModules;
    private List<Lifecycle> mAppLifecycles = new ArrayList<Lifecycle>();
    private List<Application.ActivityLifecycleCallbacks> mActivityLifecycles = new ArrayList<Application.ActivityLifecycleCallbacks>();
    private ComponentCallbacks2 mComponentCallback;

    public AppDelegate(Application application) {
        this.mApplication = application;
        this.mModules = new ManifestParser(this.mApplication).parse();
        for (ConfigModule module : this.mModules) {
            module.injectAppLifecycle((Context)this.mApplication, this.mAppLifecycles);
            module.injectActivityLifecycle((Context)this.mApplication, this.mActivityLifecycles);
        }
    }

    public void onCreate() {
        this.mAppComponent = DaggerAppComponent.builder().appModule(new AppModule(this.mApplication)).clientModule(new ClientModule()).globalConfigModule(this.getGlobalConfigModule(this.mApplication, this.mModules)).build();
        this.mAppComponent.inject(this);
        this.mAppComponent.extras().put(ConfigModule.class.getName(), this.mModules);
        this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityLifecycles) {
            this.mApplication.registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
        for (ConfigModule configModule : this.mModules) {
            configModule.registerComponents((Context)this.mApplication, this.mAppComponent.repositoryManager());
        }
        for (Lifecycle lifecycle : this.mAppLifecycles) {
            lifecycle.onCreate(this.mApplication);
        }
        this.mComponentCallback = new AppComponentCallbacks(this.mApplication, this.mAppComponent);
        this.mApplication.registerComponentCallbacks((ComponentCallbacks)this.mComponentCallback);
    }

    public void onTerminate() {
        if (this.mActivityLifecycle != null) {
            this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        }
        if (this.mComponentCallback != null) {
            this.mApplication.unregisterComponentCallbacks((ComponentCallbacks)this.mComponentCallback);
        }
        if (this.mActivityLifecycles != null && this.mActivityLifecycles.size() > 0) {
            for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityLifecycles) {
                this.mApplication.unregisterActivityLifecycleCallbacks(activityLifecycleCallbacks);
            }
        }
        if (this.mAppLifecycles != null && this.mAppLifecycles.size() > 0) {
            for (Lifecycle lifecycle : this.mAppLifecycles) {
                lifecycle.onTerminate(this.mApplication);
            }
        }
        this.mAppComponent = null;
        this.mActivityLifecycle = null;
        this.mActivityLifecycles = null;
        this.mComponentCallback = null;
        this.mAppLifecycles = null;
        this.mApplication = null;
    }

    private GlobalConfigModule getGlobalConfigModule(Application context, List<ConfigModule> modules) {
        GlobalConfigModule.Builder builder = GlobalConfigModule.builder();
        for (ConfigModule module : modules) {
            module.applyOptions((Context)context, builder);
        }
        return builder.build();
    }

    @Override
    public AppComponent getAppComponent() {
        return this.mAppComponent;
    }

    private static class AppComponentCallbacks
    implements ComponentCallbacks2 {
        private Application mApplication;
        private AppComponent mAppComponent;

        public AppComponentCallbacks(Application application, AppComponent appComponent) {
            this.mApplication = application;
            this.mAppComponent = appComponent;
        }

        public void onTrimMemory(int level) {
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.mAppComponent.imageLoader().clear((Context)this.mApplication, GlideImageConfig.builder().isClearMemory(true).build());
        }
    }

    public static interface Lifecycle {
        public void onCreate(Application var1);

        public void onTerminate(Application var1);
    }
}

