/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base.delegate;

import android.app.Activity;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.jess.arms.base.App;
import com.jess.arms.base.delegate.ActivityDelegate;
import com.jess.arms.base.delegate.IActivity;
import org.simple.eventbus.EventBus;

public class ActivityDelegateImpl
implements ActivityDelegate {
    private Activity mActivity;
    private IActivity iActivity;
    private Unbinder mUnbinder;
    public static final Parcelable.Creator<ActivityDelegateImpl> CREATOR = new Parcelable.Creator<ActivityDelegateImpl>(){

        public ActivityDelegateImpl createFromParcel(Parcel source) {
            return new ActivityDelegateImpl(source);
        }

        public ActivityDelegateImpl[] newArray(int size) {
            return new ActivityDelegateImpl[size];
        }
    };

    public ActivityDelegateImpl(Activity activity) {
        this.mActivity = activity;
        this.iActivity = (IActivity)activity;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        if (this.iActivity.useEventBus()) {
            EventBus.getDefault().register((Object)this.mActivity);
        }
        this.iActivity.setupActivityComponent(((App)this.mActivity.getApplication()).getAppComponent());
        try {
            int layoutResID = this.iActivity.initView(savedInstanceState);
            if (layoutResID != 0) {
                this.mActivity.setContentView(layoutResID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mUnbinder = ButterKnife.bind((Activity)this.mActivity);
        this.iActivity.initData(savedInstanceState);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    @Override
    public void onDestroy() {
        if (this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
        if (this.iActivity.useEventBus()) {
            EventBus.getDefault().unregister((Object)this.mActivity);
        }
        this.mUnbinder = null;
        this.iActivity = null;
        this.mActivity = null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
    }

    protected ActivityDelegateImpl(Parcel in) {
        this.mActivity = (Activity)in.readParcelable(Activity.class.getClassLoader());
        this.iActivity = (IActivity)in.readParcelable(IActivity.class.getClassLoader());
        this.mUnbinder = (Unbinder)in.readParcelable(Unbinder.class.getClassLoader());
    }
}

