/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.mvp;

import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IPresenter;
import com.jess.arms.mvp.IView;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import org.simple.eventbus.EventBus;

public class BasePresenter<M extends IModel, V extends IView>
implements IPresenter {
    protected final String TAG = this.getClass().getSimpleName();
    protected CompositeDisposable mCompositeDisposable;
    protected M mModel;
    protected V mRootView;

    public BasePresenter(M model, V rootView) {
        this.mModel = model;
        this.mRootView = rootView;
        this.onStart();
    }

    public BasePresenter(V rootView) {
        this.mRootView = rootView;
        this.onStart();
    }

    public BasePresenter() {
        this.onStart();
    }

    @Override
    public void onStart() {
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Override
    public void onDestroy() {
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.unDispose();
        if (this.mModel != null) {
            this.mModel.onDestroy();
        }
        this.mModel = null;
        this.mRootView = null;
        this.mCompositeDisposable = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected void addDispose(Disposable disposable) {
        if (this.mCompositeDisposable == null) {
            this.mCompositeDisposable = new CompositeDisposable();
        }
        this.mCompositeDisposable.add(disposable);
    }

    protected void unDispose() {
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
        }
    }
}

