/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.di.module;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.jess.arms.di.module.AppModule;
import com.jess.arms.di.module.ClientModule;
import com.jess.arms.http.GlobalHttpHandler;
import com.jess.arms.utils.DataHelper;
import com.jess.arms.widget.imageloader.BaseImageLoaderStrategy;
import com.jess.arms.widget.imageloader.glide.GlideImageLoaderStrategy;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErroListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;

@Module
public class GlobalConfigModule {
    private HttpUrl mApiUrl;
    private BaseImageLoaderStrategy mLoaderStrategy;
    private GlobalHttpHandler mHandler;
    private List<Interceptor> mInterceptors;
    private ResponseErroListener mErroListener;
    private File mCacheFile;
    private ClientModule.RetrofitConfiguration mRetrofitConfiguration;
    private ClientModule.OkhttpConfiguration mOkhttpConfiguration;
    private ClientModule.RxCacheConfiguration mRxCacheConfiguration;
    private AppModule.GsonConfiguration mGsonConfiguration;

    private GlobalConfigModule(Builder builder) {
        this.mApiUrl = builder.apiUrl;
        this.mLoaderStrategy = builder.loaderStrategy;
        this.mHandler = builder.handler;
        this.mInterceptors = builder.interceptors;
        this.mErroListener = builder.responseErroListener;
        this.mCacheFile = builder.cacheFile;
        this.mRetrofitConfiguration = builder.retrofitConfiguration;
        this.mOkhttpConfiguration = builder.okhttpConfiguration;
        this.mRxCacheConfiguration = builder.rxCacheConfiguration;
        this.mGsonConfiguration = builder.gsonConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Singleton
    @Provides
    List<Interceptor> provideInterceptors() {
        return this.mInterceptors;
    }

    @Singleton
    @Provides
    HttpUrl provideBaseUrl() {
        return this.mApiUrl == null ? HttpUrl.parse((String)"https://api.github.com/") : this.mApiUrl;
    }

    @Singleton
    @Provides
    BaseImageLoaderStrategy provideImageLoaderStrategy() {
        return this.mLoaderStrategy == null ? new GlideImageLoaderStrategy() : this.mLoaderStrategy;
    }

    @Singleton
    @Provides
    GlobalHttpHandler provideGlobalHttpHandler() {
        return this.mHandler == null ? GlobalHttpHandler.EMPTY : this.mHandler;
    }

    @Singleton
    @Provides
    File provideCacheFile(Application application) {
        return this.mCacheFile == null ? DataHelper.getCacheFile((Context)application) : this.mCacheFile;
    }

    @Singleton
    @Provides
    ResponseErroListener provideResponseErroListener() {
        return this.mErroListener == null ? ResponseErroListener.EMPTY : this.mErroListener;
    }

    @Singleton
    @Provides
    ClientModule.RetrofitConfiguration provideRetrofitConfiguration() {
        return this.mRetrofitConfiguration == null ? ClientModule.RetrofitConfiguration.EMPTY : this.mRetrofitConfiguration;
    }

    @Singleton
    @Provides
    ClientModule.OkhttpConfiguration provideOkhttpConfiguration() {
        return this.mOkhttpConfiguration == null ? ClientModule.OkhttpConfiguration.EMPTY : this.mOkhttpConfiguration;
    }

    @Singleton
    @Provides
    ClientModule.RxCacheConfiguration provideRxCacheConfiguration() {
        return this.mRxCacheConfiguration == null ? ClientModule.RxCacheConfiguration.EMPTY : this.mRxCacheConfiguration;
    }

    @Singleton
    @Provides
    AppModule.GsonConfiguration provideGsonConfiguration() {
        return this.mGsonConfiguration == null ? AppModule.GsonConfiguration.EMPTY : this.mGsonConfiguration;
    }

    public static final class Builder {
        private HttpUrl apiUrl;
        private BaseImageLoaderStrategy loaderStrategy;
        private GlobalHttpHandler handler;
        private List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private ResponseErroListener responseErroListener;
        private File cacheFile;
        private ClientModule.RetrofitConfiguration retrofitConfiguration;
        private ClientModule.OkhttpConfiguration okhttpConfiguration;
        private ClientModule.RxCacheConfiguration rxCacheConfiguration;
        private AppModule.GsonConfiguration gsonConfiguration;

        private Builder() {
        }

        public Builder baseurl(String baseurl) {
            if (TextUtils.isEmpty((CharSequence)baseurl)) {
                throw new IllegalArgumentException("baseurl can not be empty");
            }
            this.apiUrl = HttpUrl.parse((String)baseurl);
            return this;
        }

        public Builder imageLoaderStrategy(BaseImageLoaderStrategy loaderStrategy) {
            this.loaderStrategy = loaderStrategy;
            return this;
        }

        public Builder globalHttpHandler(GlobalHttpHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder responseErroListener(ResponseErroListener listener) {
            this.responseErroListener = listener;
            return this;
        }

        public Builder cacheFile(File cacheFile) {
            this.cacheFile = cacheFile;
            return this;
        }

        public Builder retrofitConfiguration(ClientModule.RetrofitConfiguration retrofitConfiguration) {
            this.retrofitConfiguration = retrofitConfiguration;
            return this;
        }

        public Builder okhttpConfiguration(ClientModule.OkhttpConfiguration okhttpConfiguration) {
            this.okhttpConfiguration = okhttpConfiguration;
            return this;
        }

        public Builder rxCacheConfiguration(ClientModule.RxCacheConfiguration rxCacheConfiguration) {
            this.rxCacheConfiguration = rxCacheConfiguration;
            return this;
        }

        public Builder gsonConfiguration(AppModule.GsonConfiguration gsonConfiguration) {
            this.gsonConfiguration = gsonConfiguration;
            return this;
        }

        public GlobalConfigModule build() {
            return new GlobalConfigModule(this);
        }
    }
}

