/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.widget.imageloader.glide;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.DrawableRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.request.target.Target;
import com.jess.arms.widget.imageloader.BaseImageLoaderStrategy;
import com.jess.arms.widget.imageloader.glide.GlideImageConfig;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class GlideImageLoaderStrategy
implements BaseImageLoaderStrategy<GlideImageConfig> {
    @Override
    public void loadImage(Context ctx, GlideImageConfig config) {
        if (ctx == null) {
            throw new IllegalStateException("Context is required");
        }
        if (config == null) {
            throw new IllegalStateException("GlideImageConfig is required");
        }
        if (TextUtils.isEmpty((CharSequence)config.getUrl())) {
            throw new IllegalStateException("url is required");
        }
        if (config.getImageView() == null) {
            throw new IllegalStateException("imageview is required");
        }
        RequestManager manager = Glide.with((Context)ctx);
        DrawableRequestBuilder requestBuilder = manager.load(config.getUrl()).crossFade().centerCrop();
        switch (config.getCacheStrategy()) {
            case 0: {
                requestBuilder.diskCacheStrategy(DiskCacheStrategy.ALL);
                break;
            }
            case 1: {
                requestBuilder.diskCacheStrategy(DiskCacheStrategy.NONE);
                break;
            }
            case 2: {
                requestBuilder.diskCacheStrategy(DiskCacheStrategy.SOURCE);
                break;
            }
            case 3: {
                requestBuilder.diskCacheStrategy(DiskCacheStrategy.RESULT);
            }
        }
        if (config.getTransformation() != null) {
            requestBuilder.transform(new BitmapTransformation[]{config.getTransformation()});
        }
        if (config.getPlaceholder() != 0) {
            requestBuilder.placeholder(config.getPlaceholder());
        }
        if (config.getErrorPic() != 0) {
            requestBuilder.error(config.getErrorPic());
        }
        requestBuilder.into(config.getImageView());
    }

    @Override
    public void clear(final Context ctx, GlideImageConfig config) {
        if (ctx == null) {
            throw new IllegalStateException("Context is required");
        }
        if (config == null) {
            throw new IllegalStateException("GlideImageConfig is required");
        }
        if (config.getImageViews() != null && config.getImageViews().length > 0) {
            for (ImageView imageView : config.getImageViews()) {
                Glide.clear((View)imageView);
            }
        }
        if (config.getTargets() != null && config.getTargets().length > 0) {
            for (ImageView imageView : config.getTargets()) {
                Glide.clear((Target)imageView);
            }
        }
        if (config.isClearDiskCache()) {
            Observable.just((Object)0).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<Integer>(){

                public void accept(@NonNull Integer integer) throws Exception {
                    Glide.get((Context)ctx).clearDiskCache();
                }
            });
        }
        if (config.isClearMemory()) {
            Glide.get((Context)ctx).clearMemory();
        }
    }
}

