/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.integration;

import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.utils.Preconditions;
import io.rx_cache2.internal.RxCache;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    private Retrofit mRetrofit;
    private RxCache mRxCache;
    private final Map<String, Object> mRetrofitServiceCache = new LinkedHashMap<String, Object>();
    private final Map<String, Object> mCacheServiceCache = new LinkedHashMap<String, Object>();

    @Inject
    public RepositoryManager(Retrofit retrofit, RxCache rxCache) {
        this.mRetrofit = retrofit;
        this.mRxCache = rxCache;
    }

    @Override
    public void injectRetrofitService(Class<?> ... services) {
        for (Class<?> service : services) {
            if (this.mRetrofitServiceCache.containsKey(service.getName())) continue;
            this.mRetrofitServiceCache.put(service.getName(), this.mRetrofit.create(service));
        }
    }

    @Override
    public void injectCacheService(Class<?> ... services) {
        for (Class<?> service : services) {
            if (this.mCacheServiceCache.containsKey(service.getName())) continue;
            this.mCacheServiceCache.put(service.getName(), this.mRxCache.using(service));
        }
    }

    @Override
    public <T> T obtainRetrofitService(Class<T> service) {
        Preconditions.checkState(this.mRetrofitServiceCache.containsKey(service.getName()), "Unable to find %s,first call injectRetrofitService(%s) in ConfigModule", service.getName(), service.getSimpleName());
        return (T)this.mRetrofitServiceCache.get(service.getName());
    }

    @Override
    public <T> T obtainCacheService(Class<T> cache) {
        Preconditions.checkState(this.mCacheServiceCache.containsKey(cache.getName()), "Unable to find %s,first call injectCacheService(%s) in ConfigModule", cache.getName(), cache.getSimpleName());
        return (T)this.mCacheServiceCache.get(cache.getName());
    }
}

