/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.di.module;

import android.app.Application;
import android.content.Context;
import com.jess.arms.di.module.ClientModule$$Lambda$1;
import com.jess.arms.di.module.ClientModule$$Lambda$4;
import com.jess.arms.http.GlobalHttpHandler;
import com.jess.arms.http.RequestInterceptor;
import com.jess.arms.utils.DataHelper;
import dagger.Module;
import dagger.Provides;
import io.rx_cache.internal.RxCache;
import io.victoralbertos.jolyglot.GsonSpeaker;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErroListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class ClientModule {
    private static final int TIME_OUT = 10;

    @Singleton
    @Provides
    Retrofit provideRetrofit(Application application, RetrofitConfiguration configuration, Retrofit.Builder builder, OkHttpClient client, HttpUrl httpUrl) {
        builder.baseUrl(httpUrl).client(client).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        configuration.configRetrofit((Context)application, builder);
        return builder.build();
    }

    @Singleton
    @Provides
    OkHttpClient provideClient(Application application, OkhttpConfiguration configuration, OkHttpClient.Builder builder, Interceptor intercept, List<Interceptor> interceptors, GlobalHttpHandler handler) {
        builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addInterceptor(ClientModule$$Lambda$1.lambdaFactory$(handler)).addNetworkInterceptor(intercept);
        if (interceptors != null && interceptors.size() > 0) {
            OkHttpClient.Builder builder2 = builder;
            builder2.getClass();
            interceptors.forEach(ClientModule$$Lambda$4.lambdaFactory$(builder2));
        }
        configuration.configOkhttp((Context)application, builder);
        return builder.build();
    }

    @Singleton
    @Provides
    Retrofit.Builder provideRetrofitBuilder() {
        return new Retrofit.Builder();
    }

    @Singleton
    @Provides
    OkHttpClient.Builder provideClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Singleton
    @Provides
    Interceptor provideInterceptor(RequestInterceptor intercept) {
        return intercept;
    }

    @Singleton
    @Provides
    RxCache provideRxCache(Application application, RxCacheConfiguration configuration, @Named(value="RxCacheDirectory") File cacheDirectory) {
        RxCache.Builder builder = new RxCache.Builder();
        configuration.configRxCache((Context)application, builder);
        return builder.persistence(cacheDirectory, (JolyglotGenerics)new GsonSpeaker());
    }

    @Singleton
    @Provides
    @Named(value="RxCacheDirectory")
    File provideRxCacheDirectory(File cacheDir) {
        File cacheDirectory = new File(cacheDir, "RxCache");
        return DataHelper.makeDirs(cacheDirectory);
    }

    @Singleton
    @Provides
    RxErrorHandler proRxErrorHandler(Application application, ResponseErroListener listener) {
        return RxErrorHandler.builder().with((Context)application).responseErroListener(listener).build();
    }

    static /* synthetic */ Response lambda$provideClient$0(GlobalHttpHandler globalHttpHandler, Interceptor.Chain chain) throws IOException {
        return chain.proceed(globalHttpHandler.onHttpRequestBefore(chain, chain.request()));
    }

    public static interface RxCacheConfiguration {
        public static final RxCacheConfiguration EMPTY = new RxCacheConfiguration(){

            @Override
            public void configRxCache(Context context, RxCache.Builder builder) {
            }
        };

        public void configRxCache(Context var1, RxCache.Builder var2);
    }

    public static interface OkhttpConfiguration {
        public static final OkhttpConfiguration EMPTY = new OkhttpConfiguration(){

            @Override
            public void configOkhttp(Context context, OkHttpClient.Builder builder) {
            }
        };

        public void configOkhttp(Context var1, OkHttpClient.Builder var2);
    }

    public static interface RetrofitConfiguration {
        public static final RetrofitConfiguration EMPTY = new RetrofitConfiguration(){

            @Override
            public void configRetrofit(Context context, Retrofit.Builder builder) {
            }
        };

        public void configRetrofit(Context var1, Retrofit.Builder var2);
    }
}

