/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.di.module;

import android.app.Application;
import android.content.Context;
import com.jess.arms.base.AppManager;
import com.jess.arms.http.RequestIntercept;
import com.jess.arms.utils.DataHelper;
import dagger.Module;
import dagger.Provides;
import io.rx_cache.internal.RxCache;
import io.victoralbertos.jolyglot.GsonSpeaker;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErroListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class ClientModule {
    private static final int TIME_OUT = 10;
    private AppManager mAppManager;

    public ClientModule(AppManager appManager) {
        this.mAppManager = appManager;
    }

    @Singleton
    @Provides
    Retrofit provideRetrofit(Retrofit.Builder builder, OkHttpClient client, HttpUrl httpUrl) {
        return builder.baseUrl(httpUrl).client(client).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
    }

    @Singleton
    @Provides
    OkHttpClient provideClient(OkHttpClient.Builder okHttpClient, Interceptor intercept, List<Interceptor> interceptors) {
        OkHttpClient.Builder builder = okHttpClient.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addNetworkInterceptor(intercept);
        if (interceptors != null && interceptors.size() > 0) {
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        return builder.build();
    }

    @Singleton
    @Provides
    Retrofit.Builder provideRetrofitBuilder() {
        return new Retrofit.Builder();
    }

    @Singleton
    @Provides
    OkHttpClient.Builder provideClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Singleton
    @Provides
    Interceptor provideIntercept(RequestIntercept intercept) {
        return intercept;
    }

    @Singleton
    @Provides
    RxCache provideRxCache(@Named(value="RxCacheDirectory") File cacheDirectory) {
        return new RxCache.Builder().persistence(cacheDirectory, (JolyglotGenerics)new GsonSpeaker());
    }

    @Singleton
    @Provides
    @Named(value="RxCacheDirectory")
    File provideRxCacheDirectory(File cacheDir) {
        File cacheDirectory = new File(cacheDir, "RxCache");
        return DataHelper.makeDirs(cacheDirectory);
    }

    @Singleton
    @Provides
    RxErrorHandler proRxErrorHandler(Application application, ResponseErroListener listener) {
        return RxErrorHandler.builder().with((Context)application).responseErroListener(listener).build();
    }

    @Singleton
    @Provides
    AppManager provideAppManager() {
        return this.mAppManager;
    }
}

