/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.mvp.Presenter;
import com.trello.rxlifecycle.components.support.RxFragment;
import javax.inject.Inject;
import org.simple.eventbus.EventBus;

public abstract class BaseFragment<P extends Presenter>
extends RxFragment {
    protected BaseActivity mActivity;
    protected View mRootView;
    protected final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    @Inject
    protected P mPresenter;
    private Unbinder mUnbinder;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = this.initView(inflater, container);
        this.mUnbinder = ButterKnife.bind((Object)((Object)this), (View)this.mRootView);
        return this.mRootView;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mActivity = (BaseActivity)this.getActivity();
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
        this.ComponentInject();
        this.initData();
    }

    protected abstract void ComponentInject();

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.mPresenter = null;
        this.mActivity = null;
        this.mRootView = null;
        this.mUnbinder = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected abstract View initView(LayoutInflater var1, ViewGroup var2);

    protected abstract void initData();

    public void setData(Object data) {
    }

    public void setData() {
    }
}

