/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.app.Application;
import android.content.Context;
import com.jess.arms.base.ActivityLifecycle;
import com.jess.arms.base.AppManager;
import com.jess.arms.di.component.DaggerBaseComponent;
import com.jess.arms.di.module.AppModule;
import com.jess.arms.di.module.ClientModule;
import com.jess.arms.di.module.GlobeConfigModule;
import com.jess.arms.di.module.ImageModule;
import com.jess.arms.utils.Preconditions;
import javax.inject.Inject;

public abstract class BaseApplication
extends Application {
    private static BaseApplication mApplication;
    private ClientModule mClientModule;
    private AppModule mAppModule;
    private ImageModule mImageModule;
    private GlobeConfigModule mGlobeConfigModule;
    @Inject
    protected AppManager mAppManager;
    @Inject
    protected ActivityLifecycle mActivityLifecycle;
    protected final String TAG = ((Object)((Object)this)).getClass().getSimpleName();

    public void onCreate() {
        super.onCreate();
        mApplication = this;
        this.mAppModule = new AppModule(this);
        DaggerBaseComponent.builder().appModule(this.mAppModule).build().inject(this);
        this.mImageModule = new ImageModule();
        this.mClientModule = new ClientModule(this.mAppManager);
        this.mGlobeConfigModule = Preconditions.checkNotNull(this.getGlobeConfigModule(), "lobeConfigModule is required");
        this.registerActivityLifecycleCallbacks(this.mActivityLifecycle);
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.mClientModule != null) {
            this.mClientModule = null;
        }
        if (this.mAppModule != null) {
            this.mAppModule = null;
        }
        if (this.mImageModule != null) {
            this.mImageModule = null;
        }
        if (this.mActivityLifecycle != null) {
            this.unregisterActivityLifecycleCallbacks(this.mActivityLifecycle);
        }
        if (this.mAppManager != null) {
            this.mAppManager.release();
            this.mAppManager = null;
        }
        if (mApplication != null) {
            mApplication = null;
        }
    }

    protected abstract GlobeConfigModule getGlobeConfigModule();

    public ClientModule getClientModule() {
        return this.mClientModule;
    }

    public AppModule getAppModule() {
        return this.mAppModule;
    }

    public ImageModule getImageModule() {
        return this.mImageModule;
    }

    public AppManager getAppManager() {
        return this.mAppManager;
    }

    public static Context getContext() {
        return mApplication;
    }
}

