/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.style.AbsoluteSizeSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import com.jess.arms.base.BaseApplication;
import java.security.MessageDigest;
import org.simple.eventbus.EventBus;

public class UiUtils {
    public static Toast mToast;

    public static void setViewHintSize(int size, TextView v, int res) {
        SpannableString ss = new SpannableString((CharSequence)UiUtils.getResources().getString(res));
        AbsoluteSizeSpan ass = new AbsoluteSizeSpan(size, true);
        ss.setSpan((Object)ass, 0, ss.length(), 33);
        v.setHint((CharSequence)new SpannedString((CharSequence)ss));
    }

    public static int dip2px(float dpValue) {
        float scale = BaseApplication.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static Resources getResources() {
        return BaseApplication.getContext().getResources();
    }

    public static String[] getStringArray(int id2) {
        return UiUtils.getResources().getStringArray(id2);
    }

    public static int pix2dip(int pix) {
        float densityDpi = UiUtils.getResources().getDisplayMetrics().density;
        return (int)((float)pix / densityDpi + 0.5f);
    }

    public static Context getContext() {
        return BaseApplication.getContext();
    }

    public static int getDimens(int homePicHeight) {
        return (int)UiUtils.getResources().getDimension(homePicHeight);
    }

    public static float getDimens(String dimenNmae) {
        return UiUtils.getResources().getDimension(UiUtils.getResources().getIdentifier(dimenNmae, "dimen", UiUtils.getContext().getPackageName()));
    }

    public static String getString(int stringID) {
        return UiUtils.getResources().getString(stringID);
    }

    public static String getString(String strName) {
        return UiUtils.getString(UiUtils.getResources().getIdentifier(strName, "string", UiUtils.getContext().getPackageName()));
    }

    public static <T extends View> T findViewByName(View view, String viewName) {
        int id2 = UiUtils.getResources().getIdentifier(viewName, "id", UiUtils.getContext().getPackageName());
        View v = view.findViewById(id2);
        return (T)v;
    }

    public static <T extends View> T findViewByName(Activity activity, String viewName) {
        int id2 = UiUtils.getResources().getIdentifier(viewName, "id", UiUtils.getContext().getPackageName());
        View v = activity.findViewById(id2);
        return (T)v;
    }

    public static int findLayout(String layoutName) {
        int id2 = UiUtils.getResources().getIdentifier(layoutName, "layout", UiUtils.getContext().getPackageName());
        return id2;
    }

    public static View inflate(int detailScreen) {
        return View.inflate((Context)UiUtils.getContext(), (int)detailScreen, null);
    }

    public static void makeText(String string) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)UiUtils.getContext(), (CharSequence)string, (int)0);
        }
        mToast.setText((CharSequence)string);
        mToast.show();
    }

    public static void SnackbarText(String text) {
        Message message = new Message();
        message.what = 1;
        message.obj = text;
        message.arg1 = 0;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void SnackbarTextWithLong(String text) {
        Message message = new Message();
        message.what = 1;
        message.obj = text;
        message.arg1 = 1;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static Drawable getDrawablebyResource(int rID) {
        return UiUtils.getResources().getDrawable(rID);
    }

    public static void startActivity(Activity activity, Class homeActivityClass) {
        Intent intent = new Intent(UiUtils.getContext(), homeActivityClass);
        activity.startActivity(intent);
    }

    public static void startActivity(Class homeActivityClass) {
        Message message = new Message();
        message.what = 0;
        message.obj = homeActivityClass;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void startActivity(Intent content) {
        Message message = new Message();
        message.what = 0;
        message.obj = content;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void startActivity(Activity activity, Intent intent) {
        activity.startActivity(intent);
    }

    public static int getLayoutId(String layoutName) {
        return UiUtils.getResources().getIdentifier(layoutName, "layout", UiUtils.getContext().getPackageName());
    }

    public static int getScreenWidth() {
        return UiUtils.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeidth() {
        return UiUtils.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getColor(int rid) {
        return UiUtils.getResources().getColor(rid);
    }

    public static int getColor(String colorName) {
        return UiUtils.getColor(UiUtils.getResources().getIdentifier(colorName, "color", UiUtils.getContext().getPackageName()));
    }

    public static void removeChild(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            group.removeView(view);
        }
    }

    public static boolean isEmpty(Object obj) {
        return obj == null;
    }

    public static String MD5encode(String string) {
        byte[] hash = new byte[]{};
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static void statuInScreen(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        attrs.flags &= 0xFFFFFBFF;
        activity.getWindow().setAttributes(attrs);
        activity.getWindow().addFlags(256);
        activity.getWindow().addFlags(512);
    }

    public static void configRecycleView(RecyclerView recyclerView, RecyclerView.LayoutManager layoutManager) {
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setHasFixedSize(true);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void killAll() {
        Message message = new Message();
        message.what = 2;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }

    public static void exitApp() {
        Message message = new Message();
        message.what = 3;
        EventBus.getDefault().post((Object)message, "appmanager_message");
    }
}

