/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.mvp;

import com.jess.arms.mvp.BaseView;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.Presenter;
import org.simple.eventbus.EventBus;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;

public class BasePresenter<M extends IModel, V extends BaseView>
implements Presenter {
    protected final String TAG = this.getClass().getSimpleName();
    protected CompositeSubscription mCompositeSubscription;
    protected M mModel;
    protected V mRootView;

    public BasePresenter(M model, V rootView) {
        this.mModel = model;
        this.mRootView = rootView;
        this.onStart();
    }

    public BasePresenter(V rootView) {
        this.mRootView = rootView;
        this.onStart();
    }

    public BasePresenter() {
        this.onStart();
    }

    @Override
    public void onStart() {
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Override
    public void onDestroy() {
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.unSubscribe();
        if (this.mModel != null) {
            this.mModel.onDestroy();
            this.mModel = null;
        }
        this.mRootView = null;
        this.mCompositeSubscription = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected void addSubscribe(Subscription subscription) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeSubscription();
        }
        this.mCompositeSubscription.add(subscription);
    }

    protected void unSubscribe() {
        if (this.mCompositeSubscription != null) {
            this.mCompositeSubscription.unsubscribe();
        }
    }
}

