/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.http;

import android.support.annotation.NonNull;
import com.jess.arms.http.GlobeHttpHandler;
import com.jess.arms.utils.CharactorHandler;
import com.jess.arms.utils.ZipHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import timber.log.Timber;

@Singleton
public class RequestIntercept
implements Interceptor {
    private GlobeHttpHandler mHandler;

    @Inject
    public RequestIntercept(GlobeHttpHandler handler) {
        this.mHandler = handler;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String bodyString;
        Request request = chain.request();
        if (this.mHandler != null) {
            request = this.mHandler.onHttpRequestBefore(chain, request);
        }
        Buffer requestbuffer = new Buffer();
        if (request.body() != null) {
            request.body().writeTo((BufferedSink)requestbuffer);
        } else {
            Timber.tag((String)"Request").w("request.body() == null", new Object[0]);
        }
        Timber.tag((String)"Request").w("Sending Request %s on %n Params --->  %s%n Connection ---> %s%n Headers ---> %s", new Object[]{request.url(), request.body() != null ? RequestIntercept.parseParams(request.body(), requestbuffer) : "null", chain.connection(), request.headers()});
        long t1 = System.nanoTime();
        Response originalResponse = chain.proceed(request);
        long t2 = System.nanoTime();
        Timber.tag((String)"Response").w("Received response  in %.1fms%n%s", new Object[]{(double)(t2 - t1) / 1000000.0, originalResponse.headers()});
        ResponseBody responseBody = originalResponse.body();
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        Buffer buffer = source.buffer();
        String encoding = originalResponse.headers().get("Content-Encoding");
        Buffer clone = buffer.clone();
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            bodyString = ZipHelper.decompressForGzip(clone.readByteArray());
        } else if (encoding != null && encoding.equalsIgnoreCase("zlib")) {
            bodyString = ZipHelper.decompressToStringForZlib(clone.readByteArray());
        } else {
            Charset charset = Charset.forName("UTF-8");
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            bodyString = clone.readString(charset);
        }
        Timber.tag((String)"Result").w(CharactorHandler.jsonFormat(bodyString), new Object[0]);
        if (this.mHandler != null) {
            return this.mHandler.onHttpResultResponse(bodyString, chain, originalResponse);
        }
        return originalResponse;
    }

    @NonNull
    public static String parseParams(RequestBody body, Buffer requestbuffer) throws UnsupportedEncodingException {
        if (body.contentType() != null && !body.contentType().toString().contains("multipart")) {
            return URLDecoder.decode(requestbuffer.readUtf8(), "UTF-8");
        }
        return "null";
    }
}

