/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.di.module;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.jess.arms.http.GlobeHttpHandler;
import com.jess.arms.utils.DataHelper;
import com.jess.arms.utils.Preconditions;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErroListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;

@Module
public class GlobeConfigModule {
    private HttpUrl mApiUrl;
    private GlobeHttpHandler mHandler;
    private List<Interceptor> mInterceptors;
    private ResponseErroListener mErroListener;
    private File mCacheFile;

    private GlobeConfigModule(Buidler buidler) {
        this.mApiUrl = buidler.apiUrl;
        this.mHandler = buidler.handler;
        this.mInterceptors = buidler.interceptors;
        this.mErroListener = buidler.responseErroListener;
        this.mCacheFile = buidler.cacheFile;
    }

    public static Buidler buidler() {
        return new Buidler();
    }

    @Singleton
    @Provides
    List<Interceptor> provideInterceptors() {
        return this.mInterceptors;
    }

    @Singleton
    @Provides
    HttpUrl provideBaseUrl() {
        return this.mApiUrl;
    }

    @Singleton
    @Provides
    GlobeHttpHandler provideGlobeHttpHandler() {
        return this.mHandler == null ? GlobeHttpHandler.EMPTY : this.mHandler;
    }

    @Singleton
    @Provides
    File provideCacheFile(Application application) {
        return this.mCacheFile == null ? DataHelper.getCacheFile((Context)application) : this.mCacheFile;
    }

    @Singleton
    @Provides
    ResponseErroListener provideResponseErroListener() {
        return this.mErroListener == null ? ResponseErroListener.EMPTY : this.mErroListener;
    }

    public static final class Buidler {
        private HttpUrl apiUrl = HttpUrl.parse((String)"https://api.github.com/");
        private GlobeHttpHandler handler;
        private List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private ResponseErroListener responseErroListener;
        private File cacheFile;

        private Buidler() {
        }

        public Buidler baseurl(String baseurl) {
            if (TextUtils.isEmpty((CharSequence)baseurl)) {
                throw new IllegalArgumentException("baseurl can not be empty");
            }
            this.apiUrl = HttpUrl.parse((String)baseurl);
            return this;
        }

        public Buidler globeHttpHandler(GlobeHttpHandler handler) {
            this.handler = handler;
            return this;
        }

        public Buidler addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Buidler responseErroListener(ResponseErroListener listener) {
            this.responseErroListener = listener;
            return this;
        }

        public Buidler cacheFile(File cacheFile) {
            this.cacheFile = cacheFile;
            return this;
        }

        public GlobeConfigModule build() {
            Preconditions.checkNotNull(this.apiUrl, "baseurl is required");
            return new GlobeConfigModule(this);
        }
    }
}

