/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.jess.arms.base.BaseApplication;
import com.jess.arms.mvp.Presenter;
import com.trello.rxlifecycle.components.support.RxAppCompatActivity;
import com.zhy.autolayout.AutoFrameLayout;
import com.zhy.autolayout.AutoLinearLayout;
import com.zhy.autolayout.AutoRelativeLayout;
import javax.inject.Inject;
import org.simple.eventbus.EventBus;

public abstract class BaseActivity<P extends Presenter>
extends RxAppCompatActivity {
    protected final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected BaseApplication mApplication;
    private Unbinder mUnbinder;
    @Inject
    protected P mPresenter;
    private static final String LAYOUT_LINEARLAYOUT = "LinearLayout";
    private static final String LAYOUT_FRAMELAYOUT = "FrameLayout";
    private static final String LAYOUT_RELATIVELAYOUT = "RelativeLayout";
    public static final String IS_NOT_ADD_ACTIVITY_LIST = "is_add_activity_list";

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        AutoFrameLayout view = null;
        if (name.equals(LAYOUT_FRAMELAYOUT)) {
            view = new AutoFrameLayout(context, attrs);
        }
        if (name.equals(LAYOUT_LINEARLAYOUT)) {
            view = new AutoLinearLayout(context, attrs);
        }
        if (name.equals(LAYOUT_RELATIVELAYOUT)) {
            view = new AutoRelativeLayout(context, attrs);
        }
        if (view != null) {
            return view;
        }
        return super.onCreateView(name, context, attrs);
    }

    @Nullable
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mApplication = (BaseApplication)this.getApplication();
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
        this.setContentView(this.initView());
        this.mUnbinder = ButterKnife.bind((Activity)this);
        this.ComponentInject();
        this.initData();
    }

    protected abstract void ComponentInject();

    public void FullScreencall() {
        if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) {
            View v = this.getWindow().getDecorView();
            v.setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 4098;
            decorView.setSystemUiVisibility(uiOptions);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
        if (this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.mPresenter = null;
        this.mUnbinder = null;
        this.mApplication = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    protected abstract View initView();

    protected abstract void initData();
}

