/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.jess.arms.base.AppManager;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private AppManager mAppManager;

    @Inject
    public ActivityLifecycle(AppManager appManager) {
        this.mAppManager = appManager;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        boolean isNotAdd = false;
        if (activity.getIntent() != null) {
            isNotAdd = activity.getIntent().getBooleanExtra("is_add_activity_list", false);
        }
        if (!isNotAdd) {
            this.mAppManager.addActivity(activity);
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.mAppManager.setCurrentActivity(activity);
    }

    public void onActivityPaused(Activity activity) {
        if (this.mAppManager.getCurrentActivity() == activity) {
            this.mAppManager.setCurrentActivity(null);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mAppManager.removeActivity(activity);
    }
}

