/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.libusbcommunication;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.github.mjdev.libaums.ErrNo;
import com.github.mjdev.libaums.usb.PipeException;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0001;B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020 H\u0016J8\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001aH\u0016J9\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0082 J\u0019\u00101\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u001aH\u0082 J\u0019\u00103\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u001aH\u0082 J\u0019\u00104\u001a\u00020 2\u0006\u0010,\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u001aH\u0082 JI\u00105\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0082 J\u0019\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u0015H\u0082 J\u0011\u00109\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u0011H\u0082 J\b\u0010:\u001a\u00020 H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006<"}, d2={"Lme/jahnen/libaums/libusbcommunication/LibusbCommunication;", "Lcom/github/mjdev/libaums/usb/UsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "deviceConnection", "Landroid/hardware/usb/UsbDeviceConnection;", "getInEndpoint", "()Landroid/hardware/usb/UsbEndpoint;", "libUsbHandle", "", "getLibUsbHandle", "()J", "libUsbHandleArray", "", "getOutEndpoint", "getUsbInterface", "()Landroid/hardware/usb/UsbInterface;", "bulkInTransfer", "", "dest", "Ljava/nio/ByteBuffer;", "bulkOutTransfer", "src", "clearFeatureHalt", "", "endpoint", "close", "controlTransfer", "requestType", "request", "value", "index", "buffer", "", "length", "nativeBulkTransfer", "handle", "endpointAddress", "data", "offset", "timeout", "nativeClaimInterface", "interfaceNumber", "nativeClearHalt", "nativeClose", "nativeControlTransfer", "nativeInit", "", "fd", "nativeReset", "resetDevice", "Companion", "libusbcommunication_release"})
public final class LibusbCommunication
implements UsbCommunication {
    private long[] libUsbHandleArray;
    private UsbDeviceConnection deviceConnection;
    @NotNull
    private final UsbInterface usbInterface;
    @NotNull
    private final UsbEndpoint outEndpoint;
    @NotNull
    private final UsbEndpoint inEndpoint;
    private static final String TAG;
    private static final int LIBUSB_EPIPE = -9;
    public static final Companion Companion;

    private final long getLibUsbHandle() {
        return this.libUsbHandleArray[0];
    }

    private final native boolean nativeInit(int var1, long[] var2);

    private final native int nativeClaimInterface(long var1, int var3);

    private final native void nativeClose(long var1, int var3);

    private final native int nativeReset(long var1);

    private final native int nativeClearHalt(long var1, int var3);

    private final native int nativeBulkTransfer(long var1, int var3, byte[] var4, int var5, int var6, int var7);

    private final native int nativeControlTransfer(long var1, int var3, int var4, int var5, int var6, byte[] var7, int var8, int var9);

    public int bulkOutTransfer(@NotNull ByteBuffer src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        long l = this.getLibUsbHandle();
        int n = this.getOutEndpoint().getAddress();
        byte[] byArray = src.array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"src.array()");
        int transferred = this.nativeBulkTransfer(l, n, byArray, src.position(), src.remaining(), 5000);
        if (transferred == LIBUSB_EPIPE) {
            throw (Throwable)new PipeException();
        }
        if (transferred < 0) {
            throw (Throwable)new IOException("libusb returned " + transferred + " in control transfer");
        }
        src.position(src.position() + transferred);
        return transferred;
    }

    public int bulkInTransfer(@NotNull ByteBuffer dest) {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        long l = this.getLibUsbHandle();
        int n = this.getInEndpoint().getAddress();
        byte[] byArray = dest.array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"dest.array()");
        int transferred = this.nativeBulkTransfer(l, n, byArray, dest.position(), dest.remaining(), 5000);
        if (transferred == LIBUSB_EPIPE) {
            throw (Throwable)new PipeException();
        }
        if (transferred < 0) {
            throw (Throwable)new IOException("libusb returned " + transferred + " in control transfer");
        }
        dest.position(dest.position() + transferred);
        return transferred;
    }

    public int controlTransfer(int requestType, int request, int value, int index, @NotNull byte[] buffer, int length) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        int ret = this.nativeControlTransfer(this.getLibUsbHandle(), requestType, request, value, index, buffer, length, 5000);
        if (ret < 0) {
            throw (Throwable)new IOException("libusb returned " + ret + " in control transfer");
        }
        return ret;
    }

    public void resetDevice() {
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        if (!usbDeviceConnection.releaseInterface(this.getUsbInterface())) {
            Log.w((String)TAG, (String)("Failed to release interface, errno: " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr()));
        }
        int ret = this.nativeReset(this.getLibUsbHandle());
        Log.d((String)TAG, (String)("libusb reset returned " + ret));
        int counter = 3;
        while (true) {
            UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection;
            if (usbDeviceConnection2 == null) {
                Intrinsics.throwNpe();
            }
            if (usbDeviceConnection2.claimInterface(this.getUsbInterface(), true) || counter < 0) break;
            if (counter == 0) {
                throw (Throwable)new IOException("Could not claim interface, errno: " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr());
            }
            Thread.sleep(800L);
            --counter;
        }
    }

    public void clearFeatureHalt(@NotNull UsbEndpoint endpoint) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        int ret = this.nativeClearHalt(this.getLibUsbHandle(), endpoint.getAddress());
        Log.d((String)TAG, (String)("libusb clearFeatureHalt returned " + ret));
    }

    public void close() {
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        usbDeviceConnection.releaseInterface(this.getUsbInterface());
        this.nativeClose(this.getLibUsbHandle(), this.getUsbInterface().getId());
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection;
        if (usbDeviceConnection2 == null) {
            Intrinsics.throwNpe();
        }
        usbDeviceConnection2.close();
    }

    @NotNull
    public UsbInterface getUsbInterface() {
        return this.usbInterface;
    }

    @NotNull
    public UsbEndpoint getOutEndpoint() {
        return this.outEndpoint;
    }

    @NotNull
    public UsbEndpoint getInEndpoint() {
        return this.inEndpoint;
    }

    public LibusbCommunication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        boolean claim;
        Intrinsics.checkParameterIsNotNull((Object)usbManager, (String)"usbManager");
        Intrinsics.checkParameterIsNotNull((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkParameterIsNotNull((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkParameterIsNotNull((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkParameterIsNotNull((Object)inEndpoint, (String)"inEndpoint");
        this.usbInterface = usbInterface;
        this.outEndpoint = outEndpoint;
        this.inEndpoint = inEndpoint;
        this.libUsbHandleArray = new long[]{0L};
        System.loadLibrary("libusbcom");
        UsbDeviceConnection usbDeviceConnection = usbManager.openDevice(usbDevice);
        if (usbDeviceConnection == null) {
            throw (Throwable)new IOException("deviceConnection is null!");
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection = usbDeviceConnection;
        if (usbDeviceConnection2 == null) {
            Intrinsics.throwNpe();
        }
        if (!this.nativeInit(usbDeviceConnection2.getFileDescriptor(), this.libUsbHandleArray)) {
            throw (Throwable)new IOException("libusb init failed");
        }
        UsbDeviceConnection usbDeviceConnection3 = this.deviceConnection;
        if (usbDeviceConnection3 == null) {
            Intrinsics.throwNpe();
        }
        if (!(claim = usbDeviceConnection3.claimInterface(this.getUsbInterface(), true))) {
            throw (Throwable)new IOException("could not claim interface!");
        }
    }

    static {
        Companion = new Companion(null);
        TAG = LibusbCommunication.class.getSimpleName();
        LIBUSB_EPIPE = -9;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lme/jahnen/libaums/libusbcommunication/LibusbCommunication$Companion;", "", "()V", "LIBUSB_EPIPE", "", "TAG", "", "kotlin.jvm.PlatformType", "libusbcommunication_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

