/*
 * Decompiled with CFR 0.152.
 */
package me.ithebk.barchart;

import android.animation.LayoutTransition;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.ithebk.barchart.BarChartModel;
import me.ithebk.barchart.BarChartUtils;
import me.ithebk.barchart.R;

public class BarChart
extends FrameLayout {
    private int barSpaces;
    private int barTextColor;
    private Context context;
    private int barType;
    private int barDimension;
    private int barTextSize;
    private int barColor;
    private boolean showAutoColorBar;
    private int barMaxValue;
    private LinearLayout verticalLinearParent;
    private LinearLayout horizontalLinearParent;
    private boolean isBarAdded = false;
    private boolean isShowBarValue = true;
    private boolean isShowAnimation = true;
    private OnBarClickListener onBarClickListener;
    private List<BarChartModel> barChartModels = new ArrayList<BarChartModel>();

    public BarChart(Context context) {
        super(context);
        this.init();
    }

    public BarChart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BarChart, 0, 0);
        this.barType = a.getInt(R.styleable.BarChart_bar_type, 1);
        this.barDimension = a.getDimensionPixelSize(R.styleable.BarChart_bar_width, (int)BarChartUtils.convertDpToPixel(20.0f, context));
        this.barColor = a.getColor(R.styleable.BarChart_bar_color, BarChartUtils.BAR_CHART_COLOR_DEFAULT);
        this.barTextSize = a.getDimensionPixelSize(R.styleable.BarChart_bar_text_size, (int)BarChartUtils.convertDpToPixel(13.0f, context));
        this.barTextSize = (int)BarChartUtils.convertPixelsToDp(this.barTextSize, context);
        this.barTextColor = a.getColor(R.styleable.BarChart_bar_text_color, BarChartUtils.BAR_CHART_TEXT_COLOR_DEFAULT);
        this.showAutoColorBar = a.getBoolean(R.styleable.BarChart_bar_show_auto_color, false);
        this.barMaxValue = a.getInt(R.styleable.BarChart_bar_max_value, 0);
        this.barSpaces = a.getDimensionPixelSize(R.styleable.BarChart_bar_spaces, (int)BarChartUtils.convertDpToPixel(BarChartUtils.BAR_CHART_SPACE, context));
        this.isShowBarValue = a.getBoolean(R.styleable.BarChart_bar_show_value, true);
        this.isShowAnimation = a.getBoolean(R.styleable.BarChart_bar_show_animation, true);
        a.recycle();
        this.init();
    }

    public List<BarChartModel> getBar() {
        return this.barChartModels;
    }

    public BarChartModel getBar(int index) {
        if (index < this.barChartModels.size()) {
            return this.barChartModels.get(index);
        }
        return null;
    }

    public int getBarMaxValue() {
        return this.barMaxValue;
    }

    public void setBarMaxValue(int barMaxValue) {
        this.barMaxValue = barMaxValue;
        this.clearAll();
    }

    private void init() {
        if (this.barType == 0) {
            this.initHorizontalChart();
        } else {
            this.initVerticalChart();
        }
    }

    private void initHorizontalChart() {
        this.horizontalLinearParent = new LinearLayout(this.context);
        this.horizontalLinearParent.setOrientation(1);
        this.horizontalLinearParent.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.horizontalLinearParent.setGravity(0x800003);
        if (this.isShowAnimation) {
            this.horizontalLinearParent.setLayoutTransition(new LayoutTransition());
        }
        this.addView((View)this.horizontalLinearParent);
    }

    private void initVerticalChart() {
        this.verticalLinearParent = new LinearLayout(this.context);
        this.verticalLinearParent.setOrientation(0);
        this.verticalLinearParent.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.verticalLinearParent.setGravity(80);
        if (this.isShowAnimation) {
            this.verticalLinearParent.setLayoutTransition(new LayoutTransition());
        }
        this.addView((View)this.verticalLinearParent);
    }

    private void createHorizontalChart(int position, int dimension, BarChartModel barChartModel) {
        if (dimension == 0 || this.barMaxValue == 0) {
            return;
        }
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.bar_horizontal, (ViewGroup)this.horizontalLinearParent, false);
        this.updateUi(position, dimension, null, barChartModel, view);
    }

    private void createVerticalChart(int position, int dimension, BarChartModel barChartModel) {
        if (dimension == 0 || this.barMaxValue == 0) {
            return;
        }
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.bar_vertical, (ViewGroup)this.verticalLinearParent, false);
        this.updateUi(position, dimension, null, barChartModel, view);
    }

    private void updateUi(int position, int dimension, BarChartModel barChartModelInit, final BarChartModel barChartModel, View view) {
        if (barChartModel.getBarColor() != 0) {
            view.findViewById(R.id.linear_bar).setBackgroundColor(barChartModel.getBarColor());
        } else if (this.showAutoColorBar) {
            view.findViewById(R.id.linear_bar).setBackgroundColor(BarChartUtils.getRandomColor());
        } else {
            view.findViewById(R.id.linear_bar).setBackgroundColor(this.barColor);
        }
        int dimensionBar = dimension * barChartModel.getBarValue() / this.barMaxValue;
        ViewGroup.MarginLayoutParams layoutParamsBar = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        if (this.isShowBarValue) {
            TextView textView = (TextView)view.findViewById(R.id.tv_bar);
            if (barChartModel.getBarText() != null) {
                textView.setText((CharSequence)String.format(Locale.getDefault(), "%s", barChartModel.getBarText()));
            } else {
                textView.setText((CharSequence)String.format(Locale.getDefault(), "%d", barChartModel.getBarValue()));
            }
            textView.setTextSize((float)this.barTextSize);
            textView.setTextColor(this.barTextColor);
        } else {
            view.findViewById(R.id.tv_bar).setVisibility(8);
        }
        final LinearLayout linearLayoutBar = (LinearLayout)view.findViewById(R.id.linear_bar);
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{barChartModelInit == null ? 0 : dimension * barChartModelInit.getBarValue() / this.barMaxValue, dimensionBar});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = linearLayoutBar.getLayoutParams();
                if (BarChart.this.barType == 1) {
                    layoutParams.height = val;
                } else {
                    layoutParams.width = val;
                }
                linearLayoutBar.setLayoutParams(layoutParams);
            }
        });
        if (this.isShowAnimation) {
            anim.setDuration(500L);
        } else {
            anim.setDuration(0L);
        }
        anim.start();
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BarChart.this.onBarClickListener != null) {
                    BarChart.this.onBarClickListener.onBarClick(barChartModel);
                }
            }
        });
        view.setTag((Object)barChartModel);
        if (this.barType == 1) {
            view.getLayoutParams().width = this.barDimension;
            if (barChartModelInit == null) {
                if (this.isBarAdded) {
                    layoutParamsBar.leftMargin = this.barSpaces;
                }
                if (position == -1) {
                    this.verticalLinearParent.addView(view);
                } else if (position <= this.verticalLinearParent.getChildCount()) {
                    this.verticalLinearParent.addView(view, position);
                }
            }
        } else {
            view.getLayoutParams().height = this.barDimension;
            if (barChartModelInit == null) {
                if (this.isBarAdded) {
                    layoutParamsBar.topMargin = this.barSpaces;
                }
                if (position == -1) {
                    this.horizontalLinearParent.addView(view);
                } else if (position <= this.horizontalLinearParent.getChildCount()) {
                    this.horizontalLinearParent.addView(view, position);
                }
            }
        }
        this.isBarAdded = true;
    }

    private void updateHorizontalChart(int dimension, BarChartModel barChartModelInit, BarChartModel barChartModel) {
        View view = this.horizontalLinearParent.findViewWithTag((Object)barChartModelInit);
        this.updateUi(-1, dimension, barChartModelInit, barChartModel, view);
    }

    private void updateVerticalChart(int dimension, BarChartModel barChartModelInit, BarChartModel barChartModel) {
        View view = this.verticalLinearParent.findViewWithTag((Object)barChartModelInit);
        this.updateUi(-1, dimension, barChartModelInit, barChartModel, view);
    }

    private void removeBarInternal(BarChartModel barChartModel) {
        if (this.barType == 0) {
            this.horizontalLinearParent.removeView(this.horizontalLinearParent.findViewWithTag((Object)barChartModel));
        } else {
            this.verticalLinearParent.removeView(this.verticalLinearParent.findViewWithTag((Object)barChartModel));
        }
    }

    private void getDimension(final boolean isHeightRequested, final View view, final DimensionReceivedCallback listener) {
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                System.out.println("Got the dimesion request onGlobalLayout");
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (isHeightRequested) {
                    listener.onDimensionReceived(view.getHeight());
                } else {
                    listener.onDimensionReceived(view.getWidth());
                }
            }
        });
    }

    public void setOnBarClickListener(OnBarClickListener onBarClickListener) {
        this.onBarClickListener = onBarClickListener;
    }

    public void addBar(List<BarChartModel> barChartModelList) {
        for (BarChartModel barChartModel : barChartModelList) {
            if (barChartModel == null) continue;
            this.addBar(this.barChartModels.size(), barChartModel);
        }
    }

    public void addBar(BarChartModel barChartModel) {
        this.addBar(this.barChartModels.size(), barChartModel);
    }

    public void addBar(final int position, final BarChartModel barChartModel) {
        if (position > this.barChartModels.size()) {
            return;
        }
        this.barChartModels.add(position, barChartModel);
        if (barChartModel != null) {
            if (this.barType == 0) {
                if (this.horizontalLinearParent.getHeight() == 0) {
                    this.getDimension(false, (View)this.horizontalLinearParent, new DimensionReceivedCallback(){

                        @Override
                        public void onDimensionReceived(int dimension) {
                            BarChart.this.createHorizontalChart(position, dimension, barChartModel);
                        }
                    });
                } else {
                    this.createHorizontalChart(position, this.horizontalLinearParent.getWidth(), barChartModel);
                }
            } else if (this.verticalLinearParent.getHeight() == 0) {
                this.getDimension(true, (View)this.verticalLinearParent, new DimensionReceivedCallback(){

                    @Override
                    public void onDimensionReceived(int dimension) {
                        BarChart.this.createVerticalChart(position, dimension, barChartModel);
                    }
                });
            } else {
                this.createVerticalChart(position, this.verticalLinearParent.getHeight(), barChartModel);
            }
        }
    }

    public void updateBar(int index, final BarChartModel barChartModel) {
        if (index >= this.barChartModels.size() || barChartModel == null) {
            return;
        }
        final BarChartModel barChartModelInit = this.barChartModels.get(index);
        this.barChartModels.set(index, barChartModel);
        if (this.barType == 0) {
            if (this.horizontalLinearParent.getHeight() == 0) {
                this.getDimension(false, (View)this.horizontalLinearParent, new DimensionReceivedCallback(){

                    @Override
                    public void onDimensionReceived(int dimension) {
                        BarChart.this.updateHorizontalChart(dimension, barChartModelInit, barChartModel);
                    }
                });
            } else {
                this.updateHorizontalChart(this.horizontalLinearParent.getWidth(), barChartModelInit, barChartModel);
            }
        } else if (this.verticalLinearParent.getHeight() == 0) {
            this.getDimension(true, (View)this.verticalLinearParent, new DimensionReceivedCallback(){

                @Override
                public void onDimensionReceived(int dimension) {
                    BarChart.this.updateVerticalChart(dimension, barChartModelInit, barChartModel);
                }
            });
        } else {
            this.updateVerticalChart(this.verticalLinearParent.getHeight(), barChartModelInit, barChartModel);
        }
    }

    public void removeBar(BarChartModel barChartModel) {
        this.barChartModels.remove(barChartModel);
        this.removeBarInternal(barChartModel);
    }

    public void removeBar(int index) {
        if (index < this.barChartModels.size()) {
            BarChartModel barChartModel = this.barChartModels.remove(index);
            this.removeBarInternal(barChartModel);
            System.out.println("barChart Val:" + barChartModel.getBarValue());
            System.out.println("barChart Val Index:" + index);
        }
    }

    public void clearAll() {
        this.barChartModels.clear();
        if (this.verticalLinearParent != null) {
            this.verticalLinearParent.removeAllViews();
        }
        if (this.horizontalLinearParent != null) {
            this.horizontalLinearParent.removeAllViews();
        }
    }

    public static interface OnBarClickListener {
        public void onBarClick(BarChartModel var1);
    }

    private static interface DimensionReceivedCallback {
        public void onDimensionReceived(int var1);
    }
}

