/*
 * Decompiled with CFR 0.152.
 */
package me.itangqi.waveloadingview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Shader;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import me.itangqi.library.R;

public class WaveLoadingView
extends View {
    private static final float DEFAULT_AMPLITUDE_RATIO = 0.1f;
    private static final float DEFAULT_WATER_LEVEL_RATIO = 0.5f;
    private static final float DEFAULT_WAVE_LENGTH_RATIO = 1.0f;
    private static final float DEFAULT_WAVE_SHIFT_RATIO = 0.0f;
    private static final int DEFAULT_WAVE_PROGRESS_VALUE = 50;
    private static final int DEFAULT_WAVE_COLOR = Color.parseColor((String)"#212121");
    private static final int DEFAULT_TITLE_COLOR = Color.parseColor((String)"#212121");
    private static final float DEFAULT_BORDER_WIDTH = 0.0f;
    private static final int DEFAULT_WAVE_SHAPE = ShapeType.CIRCLE.ordinal();
    private static final int DEFAULT_TRIANGLE_DIRECTION = TriangleDirection.NORTH.ordinal();
    private static final int DEFAULT_RECTANGLE_WIDTH = 700;
    private static final int DEFAULT_RECTANGLE_HEIGHT = 350;
    private static final int DEFAULT_ROUND_RECTANGLE_X_AND_Y = 30;
    private static final float DEFAULT_TITLE_TOP_SIZE = 18.0f;
    private static final float DEFAULT_TITLE_CENTER_SIZE = 22.0f;
    private static final float DEFAULT_TITLE_BOTTOM_SIZE = 18.0f;
    private int mCanvasSize;
    private float mAmplitudeRatio;
    private int mWaveColor;
    private int mShapeType;
    private int mShapeRectangleWidth;
    private int mShapeRectangleHeight;
    private int mTriangleDirection;
    private int mRoundRectangleXY;
    private String mTopTitle;
    private String mCenterTitle;
    private String mBottomTitle;
    private float mDefaultWaterLevel;
    private float mWaterLevelRatio = 1.0f;
    private float mWaveShiftRatio = 0.0f;
    private int mProgressValue = 50;
    private boolean mIsRoundRectangle;
    private BitmapShader mWaveShader;
    private Bitmap bitmapBuffer;
    private Matrix mShaderMatrix;
    private Paint mWavePaint;
    private Paint mBorderPaint;
    private Paint mTopTitlePaint;
    private Paint mBottomTitlePaint;
    private Paint mCenterTitlePaint;
    private AnimatorSet mAnimatorSet;
    private Context mContext;

    public WaveLoadingView(Context context) {
        this(context, null);
    }

    public WaveLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WaveLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mContext = context;
        this.mShaderMatrix = new Matrix();
        this.mWavePaint = new Paint();
        this.mWavePaint.setAntiAlias(true);
        this.initAnimation();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.WaveLoadingView, defStyleAttr, 0);
        this.mShapeType = attributes.getInteger(R.styleable.WaveLoadingView_wlv_shapeType, DEFAULT_WAVE_SHAPE);
        this.mWaveColor = attributes.getColor(R.styleable.WaveLoadingView_wlv_waveColor, DEFAULT_WAVE_COLOR);
        float amplitudeRatioAttr = attributes.getFloat(R.styleable.WaveLoadingView_wlv_waveAmplitude, 0.1f) / 1000.0f;
        this.mAmplitudeRatio = amplitudeRatioAttr > 0.1f ? 0.1f : amplitudeRatioAttr;
        this.mProgressValue = attributes.getInteger(R.styleable.WaveLoadingView_wlv_progressValue, 50);
        this.setProgressValue(this.mProgressValue);
        this.mShapeRectangleWidth = attributes.getInteger(R.styleable.WaveLoadingView_wlv_rectangle_width, 700);
        this.mShapeRectangleHeight = attributes.getInteger(R.styleable.WaveLoadingView_wlv_rectangle_height, 350);
        this.mIsRoundRectangle = attributes.getBoolean(R.styleable.WaveLoadingView_wlv_round_rectangle, false);
        this.mRoundRectangleXY = attributes.getInteger(R.styleable.WaveLoadingView_wlv_round_rectangle_x_and_y, 30);
        this.mTriangleDirection = attributes.getInteger(R.styleable.WaveLoadingView_wlv_triangle_direction, DEFAULT_TRIANGLE_DIRECTION);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth(attributes.getDimension(R.styleable.WaveLoadingView_wlv_borderWidth, (float)this.dp2px(0.0f)));
        this.mBorderPaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_wlv_borderColor, DEFAULT_WAVE_COLOR));
        this.mTopTitlePaint = new Paint();
        this.mTopTitlePaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_wlv_titleTopColor, DEFAULT_TITLE_COLOR));
        this.mTopTitlePaint.setStyle(Paint.Style.FILL);
        this.mTopTitlePaint.setAntiAlias(true);
        this.mTopTitlePaint.setTextSize(attributes.getDimension(R.styleable.WaveLoadingView_wlv_titleTopSize, (float)this.sp2px(18.0f)));
        this.mTopTitle = attributes.getString(R.styleable.WaveLoadingView_wlv_titleTop);
        this.mCenterTitlePaint = new Paint();
        this.mCenterTitlePaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_wlv_titleCenterColor, DEFAULT_TITLE_COLOR));
        this.mCenterTitlePaint.setStyle(Paint.Style.FILL);
        this.mCenterTitlePaint.setAntiAlias(true);
        this.mCenterTitlePaint.setTextSize(attributes.getDimension(R.styleable.WaveLoadingView_wlv_titleCenterSize, (float)this.sp2px(22.0f)));
        this.mCenterTitle = attributes.getString(R.styleable.WaveLoadingView_wlv_titleCenter);
        this.mBottomTitlePaint = new Paint();
        this.mBottomTitlePaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_wlv_titleBottomColor, DEFAULT_TITLE_COLOR));
        this.mBottomTitlePaint.setStyle(Paint.Style.FILL);
        this.mBottomTitlePaint.setAntiAlias(true);
        this.mBottomTitlePaint.setTextSize(attributes.getDimension(R.styleable.WaveLoadingView_wlv_titleBottomSize, (float)this.sp2px(18.0f)));
        this.mBottomTitle = attributes.getString(R.styleable.WaveLoadingView_wlv_titleBottom);
    }

    public void onDraw(Canvas canvas) {
        this.mCanvasSize = canvas.getWidth();
        if (canvas.getHeight() < this.mCanvasSize) {
            this.mCanvasSize = canvas.getHeight();
        }
        if (this.mWaveShader != null) {
            if (this.mWavePaint.getShader() == null) {
                this.mWavePaint.setShader((Shader)this.mWaveShader);
            }
            this.mShaderMatrix.setScale(1.0f, this.mAmplitudeRatio / 0.1f, 0.0f, this.mDefaultWaterLevel);
            this.mShaderMatrix.postTranslate(this.mWaveShiftRatio * (float)this.getWidth(), (0.5f - this.mWaterLevelRatio) * (float)this.getHeight());
            this.mWaveShader.setLocalMatrix(this.mShaderMatrix);
            float borderWidth = this.mBorderPaint.getStrokeWidth();
            switch (this.mShapeType) {
                case 0: {
                    Point start = new Point(0, this.getHeight());
                    Path triangle = this.getEquilateralTriangle(start, this.getWidth(), this.getHeight(), this.mTriangleDirection);
                    canvas.drawPath(triangle, this.mWavePaint);
                    break;
                }
                case 1: {
                    if (borderWidth > 0.0f) {
                        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, ((float)this.getWidth() - borderWidth) / 2.0f - 1.0f, this.mBorderPaint);
                    }
                    float radius = (float)this.getWidth() / 2.0f - borderWidth;
                    canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, radius, this.mWavePaint);
                    break;
                }
                case 2: {
                    if (borderWidth > 0.0f) {
                        canvas.drawRect(borderWidth / 2.0f, borderWidth / 2.0f, (float)this.getWidth() - borderWidth / 2.0f - 0.5f, (float)this.getHeight() - borderWidth / 2.0f - 0.5f, this.mBorderPaint);
                    }
                    canvas.drawRect(borderWidth, borderWidth, (float)this.getWidth() - borderWidth, (float)this.getHeight() - borderWidth, this.mWavePaint);
                    break;
                }
                case 3: {
                    if (this.mIsRoundRectangle) {
                        RectF rect = new RectF((float)((this.getWidth() - this.mShapeRectangleWidth) / 2), (float)(this.getHeight() - this.mShapeRectangleHeight), (float)(this.mShapeRectangleWidth + (this.getWidth() - this.mShapeRectangleWidth) / 2), (float)this.getHeight());
                        canvas.drawRoundRect(rect, (float)this.mRoundRectangleXY, (float)this.mRoundRectangleXY, this.mWavePaint);
                        break;
                    }
                    canvas.drawRect((float)((this.getWidth() - this.mShapeRectangleWidth) / 2), (float)(this.getHeight() - this.mShapeRectangleHeight), (float)(this.mShapeRectangleWidth + (this.getWidth() - this.mShapeRectangleWidth) / 2), (float)this.getHeight(), this.mWavePaint);
                    break;
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.mTopTitle)) {
                float top = this.mTopTitlePaint.measureText(this.mTopTitle);
                canvas.drawText(this.mTopTitle, ((float)this.getWidth() - top) / 2.0f, (float)(this.getHeight() * 2) / 10.0f, this.mTopTitlePaint);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mCenterTitle)) {
                float middle = this.mCenterTitlePaint.measureText(this.mCenterTitle);
                canvas.drawText(this.mCenterTitle, ((float)this.getWidth() - middle) / 2.0f, (float)(this.getHeight() / 2) - (this.mCenterTitlePaint.descent() + this.mCenterTitlePaint.ascent()) / 2.0f, this.mCenterTitlePaint);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBottomTitle)) {
                float bottom = this.mBottomTitlePaint.measureText(this.mBottomTitle);
                canvas.drawText(this.mBottomTitle, ((float)this.getWidth() - bottom) / 2.0f, (float)(this.getHeight() * 8) / 10.0f - (this.mBottomTitlePaint.descent() + this.mBottomTitlePaint.ascent()) / 2.0f, this.mBottomTitlePaint);
            }
        } else {
            this.mWavePaint.setShader(null);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCanvasSize = w;
        if (h < this.mCanvasSize) {
            this.mCanvasSize = h;
        }
        this.updateWaveShader();
    }

    private void updateWaveShader() {
        if (this.bitmapBuffer == null || this.haveBoundsChanged()) {
            if (this.bitmapBuffer != null) {
                this.bitmapBuffer.recycle();
            }
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            if (width > 0 && height > 0) {
                double defaultAngularFrequency = Math.PI * 2 / (double)width;
                float defaultAmplitude = (float)height * 0.1f;
                this.mDefaultWaterLevel = (float)height * 0.5f;
                float defaultWaveLength = width;
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                Paint wavePaint = new Paint();
                wavePaint.setStrokeWidth(2.0f);
                wavePaint.setAntiAlias(true);
                int endX = width + 1;
                int endY = height + 1;
                float[] waveY = new float[endX];
                wavePaint.setColor(this.adjustAlpha(this.mWaveColor, 0.3f));
                for (int beginX = 0; beginX < endX; ++beginX) {
                    double wx = (double)beginX * defaultAngularFrequency;
                    float beginY = (float)((double)this.mDefaultWaterLevel + (double)defaultAmplitude * Math.sin(wx));
                    canvas.drawLine((float)beginX, beginY, (float)beginX, (float)endY, wavePaint);
                    waveY[beginX] = beginY;
                }
                wavePaint.setColor(this.mWaveColor);
                int wave2Shift = (int)(defaultWaveLength / 4.0f);
                for (int beginX = 0; beginX < endX; ++beginX) {
                    canvas.drawLine((float)beginX, waveY[(beginX + wave2Shift) % endX], (float)beginX, (float)endY, wavePaint);
                }
                this.mWaveShader = new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
                this.mWavePaint.setShader((Shader)this.mWaveShader);
            }
        }
    }

    private boolean haveBoundsChanged() {
        return this.getMeasuredWidth() != this.bitmapBuffer.getWidth() || this.getMeasuredHeight() != this.bitmapBuffer.getHeight();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width = this.measureWidth(widthMeasureSpec);
        int imageSize = width < (height = this.measureHeight(heightMeasureSpec)) ? width : height;
        this.setMeasuredDimension(imageSize, imageSize);
    }

    private int measureWidth(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.mCanvasSize);
        return result;
    }

    private int measureHeight(int measureSpecHeight) {
        int specMode = View.MeasureSpec.getMode((int)measureSpecHeight);
        int specSize = View.MeasureSpec.getSize((int)measureSpecHeight);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.mCanvasSize);
        return result + 2;
    }

    public void setWaveColor(int color) {
        this.mWaveColor = color;
        this.updateWaveShader();
        this.invalidate();
    }

    public int getWaveColor() {
        return this.mWaveColor;
    }

    public void setBorderWidth(float width) {
        this.mBorderPaint.setStrokeWidth(width);
        this.invalidate();
    }

    public float getBorderWidth() {
        return this.mBorderPaint.getStrokeWidth();
    }

    public void setBorderColor(int color) {
        this.mBorderPaint.setColor(color);
        this.updateWaveShader();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.mBorderPaint.getColor();
    }

    public void setShapeType(ShapeType shapeType) {
        this.mShapeType = shapeType.ordinal();
        this.invalidate();
    }

    public int getShapeType() {
        return this.mShapeType;
    }

    public void setAmplitudeRatio(int amplitudeRatio) {
        if (this.mAmplitudeRatio != (float)amplitudeRatio / 1000.0f) {
            this.mAmplitudeRatio = (float)amplitudeRatio / 1000.0f;
            this.invalidate();
        }
    }

    public float getAmplitudeRatio() {
        return this.mAmplitudeRatio;
    }

    public void setProgressValue(int progress) {
        this.mProgressValue = progress;
        ObjectAnimator waterLevelAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"waterLevelRatio", (float[])new float[]{this.mWaterLevelRatio, (float)this.mProgressValue / 100.0f});
        waterLevelAnim.setDuration(1000L);
        waterLevelAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        AnimatorSet animatorSetProgress = new AnimatorSet();
        animatorSetProgress.play((Animator)waterLevelAnim);
        animatorSetProgress.start();
    }

    public int getProgressValue() {
        return this.mProgressValue;
    }

    public void setWaveShiftRatio(float waveShiftRatio) {
        if (this.mWaveShiftRatio != waveShiftRatio) {
            this.mWaveShiftRatio = waveShiftRatio;
            this.invalidate();
        }
    }

    public float getWaveShiftRatio() {
        return this.mWaveShiftRatio;
    }

    public void setWaterLevelRatio(float waterLevelRatio) {
        if (this.mWaterLevelRatio != waterLevelRatio) {
            this.mWaterLevelRatio = waterLevelRatio;
            this.invalidate();
        }
    }

    public float getWaterLevelRatio() {
        return this.mWaterLevelRatio;
    }

    public void setTopTitle(String topTitle) {
        this.mTopTitle = topTitle;
    }

    public String getTopTitle() {
        return this.mTopTitle;
    }

    public void setCenterTitle(String centerTitle) {
        this.mCenterTitle = centerTitle;
    }

    public String getCenterTitle() {
        return this.mCenterTitle;
    }

    public void setBottomTitle(String bottomTitle) {
        this.mBottomTitle = bottomTitle;
    }

    public String getBottomTitle() {
        return this.mBottomTitle;
    }

    public void setTopTitleColor(int topTitleColor) {
        this.mTopTitlePaint.setColor(topTitleColor);
    }

    public int getTopTitleColor() {
        return this.mTopTitlePaint.getColor();
    }

    public void setCenterTitleColor(int centerTitleColor) {
        this.mCenterTitlePaint.setColor(centerTitleColor);
    }

    public int getCenterTitleColor() {
        return this.mCenterTitlePaint.getColor();
    }

    public void setBottomTitleColor(int bottomTitleColor) {
        this.mBottomTitlePaint.setColor(bottomTitleColor);
    }

    public int getBottomTitleColor() {
        return this.mBottomTitlePaint.getColor();
    }

    public void setTopTitleSize(float topTitleSize) {
        this.mTopTitlePaint.setTextSize((float)this.sp2px(topTitleSize));
    }

    public float getsetTopTitleSize() {
        return this.mTopTitlePaint.getTextSize();
    }

    public void setCenterTitleSize(float centerTitleSize) {
        this.mCenterTitlePaint.setTextSize((float)this.sp2px(centerTitleSize));
    }

    public float getCenterTitleSize() {
        return this.mCenterTitlePaint.getTextSize();
    }

    public void setBottomTitleSize(float bottomTitleSize) {
        this.mBottomTitlePaint.setTextSize((float)this.sp2px(bottomTitleSize));
    }

    public float getBottomTitleSize() {
        return this.mBottomTitlePaint.getTextSize();
    }

    private void startAnimation() {
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.start();
        }
    }

    private void initAnimation() {
        ObjectAnimator waveShiftAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"waveShiftRatio", (float[])new float[]{0.0f, 1.0f});
        waveShiftAnim.setRepeatCount(-1);
        waveShiftAnim.setDuration(1000L);
        waveShiftAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimatorSet = new AnimatorSet();
        this.mAnimatorSet.play((Animator)waveShiftAnim);
    }

    private void cancel() {
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.end();
        }
    }

    protected void onAttachedToWindow() {
        this.startAnimation();
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.cancel();
        super.onDetachedFromWindow();
    }

    private int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private int sp2px(float spValue) {
        float fontScale = this.mContext.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    private int dp2px(float dp) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    private Path getEquilateralTriangle(Point p1, int width, int height, int direction) {
        Point p2 = null;
        Point p3 = null;
        if (direction == 0) {
            p2 = new Point(p1.x + width, p1.y);
            p3 = new Point(p1.x + width / 2, (int)((double)height - Math.sqrt(3.0) / 2.0 * (double)height));
        } else if (direction == 1) {
            p2 = new Point(p1.x, p1.y - height);
            p3 = new Point(p1.x + width, p1.y - height);
            p1.x += width / 2;
            p1.y = (int)(Math.sqrt(3.0) / 2.0 * (double)height);
        } else if (direction == 2) {
            p2 = new Point(p1.x, p1.y - height);
            p3 = new Point((int)(Math.sqrt(3.0) / 2.0 * (double)width), p1.y / 2);
        } else if (direction == 3) {
            p2 = new Point(p1.x + width, p1.y - height);
            p3 = new Point(p1.x + width, p1.y);
            p1.x = (int)((double)width - Math.sqrt(3.0) / 2.0 * (double)width);
            p1.y /= 2;
        }
        Path path = new Path();
        path.moveTo((float)p1.x, (float)p1.y);
        path.lineTo((float)p2.x, (float)p2.y);
        path.lineTo((float)p3.x, (float)p3.y);
        return path;
    }

    public static enum TriangleDirection {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }

    public static enum ShapeType {
        TRIANGLE,
        CIRCLE,
        SQUARE,
        RECTANGLE;

    }
}

