/*
 * Decompiled with CFR 0.152.
 */
package me.itangqi.waveloadingview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import me.itangqi.library.R;

public class WaveLoadingView
extends View {
    private static final float DEFAULT_AMPLITUDE_RATIO = 0.1f;
    private static final float DEFAULT_WATER_LEVEL_RATIO = 0.5f;
    private static final float DEFAULT_WAVE_LENGTH_RATIO = 1.0f;
    private static final float DEFAULT_WAVE_SHIFT_RATIO = 0.0f;
    private static final int DEFAULT_WAVE_PROGRESS_VALUE = 50;
    private static final int DEFAULT_WAVE_COLOR = Color.parseColor((String)"#212121");
    private static final int DEFAULT_TITLE_COLOR = Color.parseColor((String)"#212121");
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_WAVE_SHAPE = ShapeType.CIRCLE.ordinal();
    private static final float DEFAULT_TITLE_TOP_SIZE = 18.0f;
    private static final float DEFAULT_TITLE_CENTER_SIZE = 22.0f;
    private static final float DEFAULT_TITLE_BOTTOM_SIZE = 18.0f;
    private int mCanvasSize;
    private float mAmplitudeRatio;
    private int mWaveColor;
    private String mTopTitle;
    private String mCenterTitle;
    private String mBottomTitle;
    private int mShapeType;
    private float mDefaultWaterLevel;
    private float mWaterLevelRatio = 1.0f;
    private float mWaveShiftRatio = 0.0f;
    private int mProgressValue = 50;
    private BitmapShader mWaveShader;
    private Matrix mShaderMatrix;
    private Paint mWavePaint;
    private Paint mBorderPaint;
    private Paint mTopTitlePaint;
    private Paint mBottomTitlePaint;
    private Paint mCenterTitlePaint;
    private AnimatorSet mAnimatorSet;

    public WaveLoadingView(Context context) {
        this(context, null);
    }

    public WaveLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WaveLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mShaderMatrix = new Matrix();
        this.mWavePaint = new Paint();
        this.mWavePaint.setAntiAlias(true);
        this.initAnimation();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.WaveLoadingView, defStyleAttr, 0);
        this.mShapeType = attributes.getInteger(R.styleable.WaveLoadingView_shapeType, DEFAULT_WAVE_SHAPE);
        this.mWaveColor = attributes.getColor(R.styleable.WaveLoadingView_waveColor, DEFAULT_WAVE_COLOR);
        float amplitudeRatioAttr = attributes.getFloat(R.styleable.WaveLoadingView_waveAmplitude, 0.1f) / 1000.0f;
        this.mAmplitudeRatio = amplitudeRatioAttr > 0.1f ? 0.1f : amplitudeRatioAttr;
        this.mProgressValue = attributes.getInteger(R.styleable.WaveLoadingView_progressValue, 50);
        this.setProgressValue(this.mProgressValue);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)attributes.getInteger(R.styleable.WaveLoadingView_borderWidth, 0));
        this.mBorderPaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_borderColor, DEFAULT_WAVE_COLOR));
        this.mTopTitlePaint = new Paint();
        this.mTopTitlePaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_titleTopColor, DEFAULT_TITLE_COLOR));
        this.mTopTitlePaint.setStyle(Paint.Style.FILL);
        this.mTopTitlePaint.setAntiAlias(true);
        this.mTopTitlePaint.setTextSize((float)this.sp2px(attributes.getFloat(R.styleable.WaveLoadingView_titleTopSize, 18.0f)));
        this.mTopTitle = attributes.getString(R.styleable.WaveLoadingView_titleTop);
        this.mCenterTitlePaint = new Paint();
        this.mCenterTitlePaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_titleCenterColor, DEFAULT_TITLE_COLOR));
        this.mCenterTitlePaint.setStyle(Paint.Style.FILL);
        this.mCenterTitlePaint.setAntiAlias(true);
        this.mCenterTitlePaint.setTextSize((float)this.sp2px(attributes.getFloat(R.styleable.WaveLoadingView_titleCenterSize, 22.0f)));
        this.mCenterTitle = attributes.getString(R.styleable.WaveLoadingView_titleCenter);
        this.mBottomTitlePaint = new Paint();
        this.mBottomTitlePaint.setColor(attributes.getColor(R.styleable.WaveLoadingView_titleBottomColor, DEFAULT_TITLE_COLOR));
        this.mBottomTitlePaint.setStyle(Paint.Style.FILL);
        this.mBottomTitlePaint.setAntiAlias(true);
        this.mBottomTitlePaint.setTextSize((float)this.sp2px(attributes.getFloat(R.styleable.WaveLoadingView_titleBottomSize, 18.0f)));
        this.mBottomTitle = attributes.getString(R.styleable.WaveLoadingView_titleBottom);
    }

    public void onDraw(Canvas canvas) {
        this.mCanvasSize = canvas.getWidth();
        if (canvas.getHeight() < this.mCanvasSize) {
            this.mCanvasSize = canvas.getHeight();
        }
        if (this.mWaveShader != null) {
            if (this.mWavePaint.getShader() == null) {
                this.mWavePaint.setShader((Shader)this.mWaveShader);
            }
            this.mShaderMatrix.setScale(1.0f, this.mAmplitudeRatio / 0.1f, 0.0f, this.mDefaultWaterLevel);
            this.mShaderMatrix.postTranslate(this.mWaveShiftRatio * (float)this.getWidth(), (0.5f - this.mWaterLevelRatio) * (float)this.getHeight());
            this.mWaveShader.setLocalMatrix(this.mShaderMatrix);
            float borderWidth = this.mBorderPaint.getStrokeWidth();
            switch (this.mShapeType) {
                case 0: {
                    if (borderWidth > 0.0f) {
                        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, ((float)this.getWidth() - borderWidth) / 2.0f - 1.0f, this.mBorderPaint);
                    }
                    float radius = (float)this.getWidth() / 2.0f - borderWidth;
                    canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, radius, this.mWavePaint);
                    break;
                }
                case 1: {
                    if (borderWidth > 0.0f) {
                        canvas.drawRect(borderWidth / 2.0f, borderWidth / 2.0f, (float)this.getWidth() - borderWidth / 2.0f - 0.5f, (float)this.getHeight() - borderWidth / 2.0f - 0.5f, this.mBorderPaint);
                    }
                    canvas.drawRect(borderWidth, borderWidth, (float)this.getWidth() - borderWidth, (float)this.getHeight() - borderWidth, this.mWavePaint);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.mTopTitle)) {
                float top = this.mTopTitlePaint.measureText(this.mTopTitle);
                canvas.drawText(this.mTopTitle, ((float)this.getWidth() - top) / 2.0f, (float)(this.getHeight() * 2) / 10.0f, this.mTopTitlePaint);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mCenterTitle)) {
                float middle = this.mCenterTitlePaint.measureText(this.mCenterTitle);
                canvas.drawText(this.mCenterTitle, ((float)this.getWidth() - middle) / 2.0f, (float)(this.getHeight() / 2) - (this.mCenterTitlePaint.descent() + this.mCenterTitlePaint.ascent()) / 2.0f, this.mCenterTitlePaint);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBottomTitle)) {
                float bottom = this.mBottomTitlePaint.measureText(this.mBottomTitle);
                canvas.drawText(this.mBottomTitle, ((float)this.getWidth() - bottom) / 2.0f, (float)(this.getHeight() * 8) / 10.0f - (this.mBottomTitlePaint.descent() + this.mBottomTitlePaint.ascent()) / 2.0f, this.mBottomTitlePaint);
            }
        } else {
            this.mWavePaint.setShader(null);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCanvasSize = w;
        if (h < this.mCanvasSize) {
            this.mCanvasSize = h;
        }
        this.updateWaveShader();
    }

    private void updateWaveShader() {
        double defaultAngularFrequency = Math.PI * 2 / (double)this.getWidth();
        float defaultAmplitude = (float)this.getHeight() * 0.1f;
        this.mDefaultWaterLevel = (float)this.getHeight() * 0.5f;
        float defaultWaveLength = this.getWidth();
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint wavePaint = new Paint();
        wavePaint.setStrokeWidth(2.0f);
        wavePaint.setAntiAlias(true);
        int endX = this.getWidth() + 1;
        int endY = this.getHeight() + 1;
        float[] waveY = new float[endX];
        wavePaint.setColor(this.adjustAlpha(this.mWaveColor, 0.3f));
        for (int beginX = 0; beginX < endX; ++beginX) {
            double wx = (double)beginX * defaultAngularFrequency;
            float beginY = (float)((double)this.mDefaultWaterLevel + (double)defaultAmplitude * Math.sin(wx));
            canvas.drawLine((float)beginX, beginY, (float)beginX, (float)endY, wavePaint);
            waveY[beginX] = beginY;
        }
        wavePaint.setColor(this.mWaveColor);
        int wave2Shift = (int)(defaultWaveLength / 4.0f);
        for (int beginX = 0; beginX < endX; ++beginX) {
            canvas.drawLine((float)beginX, waveY[(beginX + wave2Shift) % endX], (float)beginX, (float)endY, wavePaint);
        }
        this.mWaveShader = new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
        this.mWavePaint.setShader((Shader)this.mWaveShader);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width = this.measureWidth(widthMeasureSpec);
        int imageSize = width < (height = this.measureHeight(heightMeasureSpec)) ? width : height;
        this.setMeasuredDimension(imageSize, imageSize);
    }

    private int measureWidth(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.mCanvasSize);
        return result;
    }

    private int measureHeight(int measureSpecHeight) {
        int specMode = View.MeasureSpec.getMode((int)measureSpecHeight);
        int specSize = View.MeasureSpec.getSize((int)measureSpecHeight);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.mCanvasSize);
        return result + 2;
    }

    public void setWaveColor(int color) {
        this.mWaveColor = color;
        this.updateWaveShader();
        this.invalidate();
    }

    public int getWaveColor() {
        return this.mWaveColor;
    }

    public void setBorderWidth(float width) {
        this.mBorderPaint.setStrokeWidth(width);
        this.invalidate();
    }

    public float getBorderWidth() {
        return this.mBorderPaint.getColor();
    }

    public void setBorderColor(int color) {
        this.mBorderPaint.setColor(color);
        this.updateWaveShader();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.mBorderPaint.getColor();
    }

    public void setShapeType(ShapeType shapeType) {
        this.mShapeType = shapeType.ordinal();
        this.invalidate();
    }

    public int getShapeType() {
        return this.mShapeType;
    }

    public void setAmplitudeRatio(int amplitudeRatio) {
        if (this.mAmplitudeRatio != (float)amplitudeRatio / 1000.0f) {
            this.mAmplitudeRatio = (float)amplitudeRatio / 1000.0f;
            this.invalidate();
        }
    }

    public float getAmplitudeRatio() {
        return this.mAmplitudeRatio;
    }

    public void setProgressValue(int progress) {
        ObjectAnimator waterLevelAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"waterLevelRatio", (float[])new float[]{this.mWaterLevelRatio, 1.0f - (float)progress / 100.0f});
        waterLevelAnim.setDuration(1000L);
        waterLevelAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        AnimatorSet animatorSetProgress = new AnimatorSet();
        animatorSetProgress.play((Animator)waterLevelAnim);
        animatorSetProgress.start();
    }

    public int getProgressValue() {
        return this.mProgressValue;
    }

    public void setWaveShiftRatio(float waveShiftRatio) {
        if (this.mWaveShiftRatio != waveShiftRatio) {
            this.mWaveShiftRatio = waveShiftRatio;
            this.invalidate();
        }
    }

    public float getWaveShiftRatio() {
        return this.mWaveShiftRatio;
    }

    public void setWaterLevelRatio(float waterLevelRatio) {
        if (this.mWaterLevelRatio != waterLevelRatio) {
            this.mWaterLevelRatio = waterLevelRatio;
            this.invalidate();
        }
    }

    public float getWaterLevelRatio() {
        return this.mWaterLevelRatio;
    }

    public void setTopTitle(String topTitle) {
        this.mTopTitle = topTitle;
    }

    public String getTopTitle() {
        return this.mTopTitle;
    }

    public void setCenterTitle(String centerTitle) {
        this.mCenterTitle = centerTitle;
    }

    public String getCenterTitle() {
        return this.mCenterTitle;
    }

    public void setBottomTitle(String bottomTitle) {
        this.mBottomTitle = bottomTitle;
    }

    public String getBottomTitle() {
        return this.mBottomTitle;
    }

    public void setTopTitleColor(int topTitleColor) {
        this.mTopTitlePaint.setColor(topTitleColor);
    }

    public int getTopTitleColor() {
        return this.mTopTitlePaint.getColor();
    }

    public void setCenterTitleColor(int centerTitleColor) {
        this.mCenterTitlePaint.setColor(centerTitleColor);
    }

    public int getCenterTitleColor() {
        return this.mCenterTitlePaint.getColor();
    }

    public void setBottomTitleColor(int bottomTitleColor) {
        this.mBottomTitlePaint.setColor(bottomTitleColor);
    }

    public int getBottomTitleColor() {
        return this.mBottomTitlePaint.getColor();
    }

    public void setTopTitleSize(float topTitleSize) {
        this.mTopTitlePaint.setTextSize((float)this.sp2px(topTitleSize));
    }

    public float getsetTopTitleSize() {
        return this.mTopTitlePaint.getTextSize();
    }

    public void setCenterTitleSize(float centerTitleSize) {
        this.mCenterTitlePaint.setTextSize((float)this.sp2px(centerTitleSize));
    }

    public float getCenterTitleSize() {
        return this.mCenterTitlePaint.getTextSize();
    }

    public void setBottomTitleSize(float bottomTitleSize) {
        this.mBottomTitlePaint.setTextSize((float)this.sp2px(bottomTitleSize));
    }

    public float getBottomTitleSize() {
        return this.mBottomTitlePaint.getTextSize();
    }

    private void startAnimation() {
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.start();
        }
    }

    private void initAnimation() {
        ObjectAnimator waveShiftAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"waveShiftRatio", (float[])new float[]{0.0f, 1.0f});
        waveShiftAnim.setRepeatCount(-1);
        waveShiftAnim.setDuration(1000L);
        waveShiftAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimatorSet = new AnimatorSet();
        this.mAnimatorSet.play((Animator)waveShiftAnim);
    }

    private void cancel() {
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.end();
        }
    }

    protected void onAttachedToWindow() {
        this.startAnimation();
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.cancel();
        super.onDetachedFromWindow();
    }

    private int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public int sp2px(float spValue) {
        float fontScale = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static enum ShapeType {
        CIRCLE,
        SQUARE;

    }
}

