/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.gpxparser.modal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import me.himanshusoni.gpxparser.modal.Extension;
import me.himanshusoni.gpxparser.modal.Link;
import me.himanshusoni.gpxparser.type.Fix;

public class Waypoint
extends Extension {
    private double latitude;
    private double longitude;
    private double elevation;
    private Date time;
    private double magneticVariation;
    private double geoIdHeight;
    private String name;
    private String comment;
    private String description;
    private String src;
    private HashSet<Link> links;
    private String sym;
    private String type;
    private Fix fix;
    private int sat;
    private double hdop;
    private double vdop;
    private double pdop;
    private double ageOfGpsData;
    private int dGpsStationId;

    public Waypoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getAgeOfGPSData() {
        return this.ageOfGpsData;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDescription() {
        return this.description;
    }

    public int getdGpsStationId() {
        return this.dGpsStationId;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Fix getFix() {
        return this.fix;
    }

    public double getGeoIdHeight() {
        return this.geoIdHeight;
    }

    public double getHdop() {
        return this.hdop;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getMagneticVariation() {
        return this.magneticVariation;
    }

    public String getName() {
        return this.name;
    }

    public double getPdop() {
        return this.pdop;
    }

    public int getSat() {
        return this.sat;
    }

    public String getSrc() {
        return this.src;
    }

    public String getSym() {
        return this.sym;
    }

    public Date getTime() {
        return this.time;
    }

    public String getType() {
        return this.type;
    }

    public double getVdop() {
        return this.vdop;
    }

    public void setAgeOfGPSData(double ageOfGPSData) {
        this.ageOfGpsData = ageOfGPSData;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setdGpsStationId(int dGpsStationId) {
        this.dGpsStationId = dGpsStationId;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public void setFix(Fix fix) {
        this.fix = fix;
    }

    public void setGeoIdHeight(double geoIdHeight) {
        this.geoIdHeight = geoIdHeight;
    }

    public void setHdop(double hdop) {
        this.hdop = hdop;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setMagneticVariation(double magVar) {
        this.magneticVariation = magVar;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPdop(double pdop) {
        this.pdop = pdop;
    }

    public void setSat(int sat) {
        this.sat = sat;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setSym(String sym) {
        this.sym = sym;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVdop(double vdop) {
        this.vdop = vdop;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String date = "";
        if (this.time != null) {
            date = sdf.format(this.time);
        }
        sb.append("[");
        sb.append("name:'" + this.name + "' ");
        sb.append("lat:" + this.latitude + " ");
        sb.append("lon:" + this.longitude + " ");
        sb.append("elv:" + this.elevation + " ");
        sb.append("time:" + date + " ");
        sb.append("fix:" + this.fix + " ");
        if (this.extensionData != null) {
            sb.append("extensions:{");
            Iterator it = this.extensionData.keySet().iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }

    public HashSet<Link> getLinks() {
        return this.links;
    }

    public void setLinks(HashSet<Link> links) {
        this.links = links;
    }

    public void addLink(Link link) {
        if (this.links == null) {
            this.links = new HashSet();
        }
        this.links.add(link);
    }
}

