/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.gpxparser;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import me.himanshusoni.gpxparser.BaseGPX;
import me.himanshusoni.gpxparser.extension.DummyExtensionParser;
import me.himanshusoni.gpxparser.extension.IExtensionParser;
import me.himanshusoni.gpxparser.modal.Bounds;
import me.himanshusoni.gpxparser.modal.Copyright;
import me.himanshusoni.gpxparser.modal.Email;
import me.himanshusoni.gpxparser.modal.Extension;
import me.himanshusoni.gpxparser.modal.GPX;
import me.himanshusoni.gpxparser.modal.Link;
import me.himanshusoni.gpxparser.modal.Metadata;
import me.himanshusoni.gpxparser.modal.Person;
import me.himanshusoni.gpxparser.modal.Route;
import me.himanshusoni.gpxparser.modal.Track;
import me.himanshusoni.gpxparser.modal.TrackSegment;
import me.himanshusoni.gpxparser.modal.Waypoint;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GPXWriter
extends BaseGPX {
    public void writeGPX(GPX gpx, OutputStream out) throws ParserConfigurationException, TransformerException {
        if (this.extensionParsers.isEmpty()) {
            this.extensionParsers.add(new DummyExtensionParser());
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element gpxNode = doc.createElement("gpx");
        NamedNodeMap attrs = gpxNode.getAttributes();
        if (gpx.getVersion() != null) {
            Attr verNode = doc.createAttribute("version");
            verNode.setNodeValue(gpx.getVersion());
            attrs.setNamedItem(verNode);
        }
        if (gpx.getCreator() != null) {
            Iterator<Extension> creatorNode = doc.createAttribute("creator");
            creatorNode.setNodeValue(gpx.getCreator());
            attrs.setNamedItem((Node)((Object)creatorNode));
        }
        if (gpx.getXmlns() != null && !gpx.getXmlns().isEmpty()) {
            for (Map.Entry entry : gpx.getXmlns().entrySet()) {
                Attr xmlnsNode = doc.createAttribute((String)entry.getKey());
                xmlnsNode.setNodeValue((String)entry.getValue());
                attrs.setNamedItem(xmlnsNode);
            }
        }
        if (gpx.getMetadata() != null) {
            this.addMetadataToNode(gpx.getMetadata(), gpxNode, doc);
        }
        if (gpx.getWaypoints() != null) {
            for (Waypoint waypoint : gpx.getWaypoints()) {
                this.addWaypointToNode("wpt", waypoint, gpxNode, doc);
            }
        }
        if (gpx.getRoutes() != null) {
            for (Route route : gpx.getRoutes()) {
                this.addRouteToNode(route, gpxNode, doc);
            }
        }
        if (gpx.getTracks() != null) {
            for (Track track : gpx.getTracks()) {
                this.addTrackToNode(track, gpxNode, doc);
            }
        }
        doc.appendChild(gpxNode);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
    }

    private void addTrackToNode(Track trk, Node n, Document doc) {
        Object node;
        Element trkNode = doc.createElement("trk");
        if (trk.getName() != null) {
            node = doc.createElement("name");
            node.appendChild(doc.createTextNode(trk.getName()));
            trkNode.appendChild((Node)node);
        }
        if (trk.getComment() != null) {
            node = doc.createElement("cmt");
            node.appendChild(doc.createTextNode(trk.getComment()));
            trkNode.appendChild((Node)node);
        }
        if (trk.getDescription() != null) {
            node = doc.createElement("desc");
            node.appendChild(doc.createTextNode(trk.getDescription()));
            trkNode.appendChild((Node)node);
        }
        if (trk.getSrc() != null) {
            node = doc.createElement("src");
            node.appendChild(doc.createTextNode(trk.getSrc()));
            trkNode.appendChild((Node)node);
        }
        if (trk.getLinks() != null) {
            for (Link l : trk.getLinks()) {
                this.addLinkToNode(l, trkNode, doc);
            }
        }
        if (trk.getNumber() != null) {
            node = doc.createElement("number");
            node.appendChild(doc.createTextNode(trk.getNumber().toString()));
            trkNode.appendChild((Node)node);
        }
        if (trk.getType() != null) {
            node = doc.createElement("type");
            node.appendChild(doc.createTextNode(trk.getType()));
            trkNode.appendChild((Node)node);
        }
        this.addExtensionToNode(trk, trkNode, doc);
        if (trk.getTrackSegments() != null) {
            for (TrackSegment ts : trk.getTrackSegments()) {
                this.addTrackSegmentToNode(ts, trkNode, doc);
            }
        }
        n.appendChild(trkNode);
    }

    private void addTrackSegmentToNode(TrackSegment ts, Node n, Document doc) {
        Element tsNode = doc.createElement("trkseg");
        for (Waypoint wp : ts.getWaypoints()) {
            this.addWaypointToNode("trkpt", wp, tsNode, doc);
        }
        this.addExtensionToNode(ts, tsNode, doc);
        n.appendChild(tsNode);
    }

    private void addRouteToNode(Route rte, Node gpxNode, Document doc) {
        Object node;
        Element rteNode = doc.createElement("rte");
        if (rte.getName() != null) {
            node = doc.createElement("name");
            node.appendChild(doc.createTextNode(rte.getName()));
            rteNode.appendChild((Node)node);
        }
        if (rte.getComment() != null) {
            node = doc.createElement("cmt");
            node.appendChild(doc.createTextNode(rte.getComment()));
            rteNode.appendChild((Node)node);
        }
        if (rte.getDescription() != null) {
            node = doc.createElement("desc");
            node.appendChild(doc.createTextNode(rte.getDescription()));
            rteNode.appendChild((Node)node);
        }
        if (rte.getSrc() != null) {
            node = doc.createElement("src");
            node.appendChild(doc.createTextNode(rte.getSrc()));
            rteNode.appendChild((Node)node);
        }
        if (rte.getLinks() != null) {
            for (Link l : rte.getLinks()) {
                this.addLinkToNode(l, rteNode, doc);
            }
        }
        if (rte.getNumber() != null) {
            node = doc.createElement("number");
            node.appendChild(doc.createTextNode(rte.getNumber().toString()));
            rteNode.appendChild((Node)node);
        }
        if (rte.getType() != null) {
            node = doc.createElement("type");
            node.appendChild(doc.createTextNode(rte.getType()));
            rteNode.appendChild((Node)node);
        }
        this.addExtensionToNode(rte, rteNode, doc);
        if (rte.getRoutePoints() != null) {
            for (Waypoint waypoint : rte.getRoutePoints()) {
                this.addWaypointToNode("rtept", waypoint, rteNode, doc);
            }
        }
        gpxNode.appendChild(rteNode);
    }

    private void addWaypointToNode(String tag, Waypoint wpt, Node n, Document doc) {
        Object node;
        Element wptNode = doc.createElement(tag);
        NamedNodeMap attrs = wptNode.getAttributes();
        if (wpt.getLatitude() != 0.0) {
            Attr latNode = doc.createAttribute("lat");
            latNode.setNodeValue(String.valueOf(wpt.getLatitude()));
            attrs.setNamedItem(latNode);
        }
        if (wpt.getLongitude() != 0.0) {
            Attr longNode = doc.createAttribute("lon");
            longNode.setNodeValue(String.valueOf(wpt.getLongitude()));
            attrs.setNamedItem(longNode);
        }
        if (wpt.getElevation() != 0.0) {
            node = doc.createElement("ele");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getElevation())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getTime() != null) {
            node = doc.createElement("time");
            node.appendChild(doc.createTextNode(xmlDateFormat.format(wpt.getTime())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getMagneticVariation() != 0.0) {
            node = doc.createElement("magvar");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getMagneticVariation())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getGeoIdHeight() != 0.0) {
            node = doc.createElement("geoidheight");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getGeoIdHeight())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getName() != null) {
            node = doc.createElement("name");
            node.appendChild(doc.createTextNode(wpt.getName()));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getComment() != null) {
            node = doc.createElement("cmt");
            node.appendChild(doc.createTextNode(wpt.getComment()));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getDescription() != null) {
            node = doc.createElement("desc");
            node.appendChild(doc.createTextNode(wpt.getDescription()));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getSrc() != null) {
            node = doc.createElement("src");
            node.appendChild(doc.createTextNode(wpt.getSrc()));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getLinks() != null) {
            for (Link l : wpt.getLinks()) {
                this.addLinkToNode(l, wptNode, doc);
            }
        }
        if (wpt.getSym() != null) {
            node = doc.createElement("sym");
            node.appendChild(doc.createTextNode(wpt.getSym()));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getType() != null) {
            node = doc.createElement("type");
            node.appendChild(doc.createTextNode(wpt.getType()));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getFix() != null) {
            node = doc.createElement("fix");
            node.appendChild(doc.createTextNode(wpt.getFix().toString()));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getSat() != 0) {
            node = doc.createElement("sat");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getSat())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getHdop() != 0.0) {
            node = doc.createElement("hdop");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getHdop())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getVdop() != 0.0) {
            node = doc.createElement("vdop");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getVdop())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getPdop() != 0.0) {
            node = doc.createElement("pdop");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getPdop())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getAgeOfGPSData() != 0.0) {
            node = doc.createElement("ageofdgpsdata");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getAgeOfGPSData())));
            wptNode.appendChild((Node)node);
        }
        if (wpt.getdGpsStationId() != 0) {
            node = doc.createElement("dgpsid");
            node.appendChild(doc.createTextNode(String.valueOf(wpt.getdGpsStationId())));
            wptNode.appendChild((Node)node);
        }
        this.addExtensionToNode(wpt, wptNode, doc);
        n.appendChild(wptNode);
    }

    private void addMetadataToNode(Metadata m, Node n, Document doc) {
        Object node;
        Element matadataNode = doc.createElement("metadata");
        if (m.getName() != null) {
            node = doc.createElement("name");
            node.appendChild(doc.createTextNode(m.getName()));
            matadataNode.appendChild((Node)node);
        }
        if (m.getDesc() != null) {
            node = doc.createElement("desc");
            node.appendChild(doc.createTextNode(m.getDesc()));
            matadataNode.appendChild((Node)node);
        }
        if (m.getAuthor() != null) {
            this.addAuthorToNode(m.getAuthor(), matadataNode, doc);
        }
        if (m.getCopyright() != null) {
            this.addCopyrightToNode(m.getCopyright(), matadataNode, doc);
        }
        if (m.getLinks() != null) {
            for (Link l : m.getLinks()) {
                this.addLinkToNode(l, matadataNode, doc);
            }
        }
        if (m.getTime() != null) {
            node = doc.createElement("time");
            node.appendChild(doc.createTextNode(xmlDateFormat.format(m.getTime())));
            matadataNode.appendChild((Node)node);
        }
        if (m.getKeywords() != null) {
            node = doc.createElement("keywords");
            node.appendChild(doc.createTextNode(m.getKeywords()));
            matadataNode.appendChild((Node)node);
        }
        if (m.getBounds() != null) {
            this.addBoundsToNode(m.getBounds(), matadataNode, doc);
        }
        this.addExtensionToNode(m, matadataNode, doc);
        n.appendChild(matadataNode);
    }

    private void addBoundsToNode(Bounds bounds, Node n, Document doc) {
        Element boundsNode = doc.createElement("bounds");
        NamedNodeMap attributes = boundsNode.getAttributes();
        Attr node = doc.createAttribute("minlat");
        node.setNodeValue(String.valueOf(bounds.getMinLat()));
        attributes.setNamedItem(node);
        node = doc.createAttribute("minlon");
        node.setNodeValue(String.valueOf(bounds.getMinLon()));
        attributes.setNamedItem(node);
        node = doc.createAttribute("maxlat");
        node.setNodeValue(String.valueOf(bounds.getMaxLat()));
        attributes.setNamedItem(node);
        node = doc.createAttribute("maxlon");
        node.setNodeValue(String.valueOf(bounds.getMaxLon()));
        attributes.setNamedItem(node);
        n.appendChild(boundsNode);
    }

    private void addCopyrightToNode(Copyright copyright, Node n, Document doc) {
        Node node;
        Element copyrightNode = doc.createElement("copyright");
        NamedNodeMap attributes = copyrightNode.getAttributes();
        if (copyright.getAuthor() != null) {
            node = doc.createAttribute("author");
            node.setNodeValue(copyright.getAuthor());
            attributes.setNamedItem(node);
        }
        if (copyright.getYear() != null) {
            node = doc.createElement("year");
            node.appendChild(doc.createTextNode(copyright.getYear()));
            copyrightNode.appendChild(node);
        }
        if (copyright.getLicense() != null) {
            node = doc.createElement("license");
            node.appendChild(doc.createTextNode(copyright.getLicense()));
            copyrightNode.appendChild(node);
        }
        n.appendChild(copyrightNode);
    }

    private void addAuthorToNode(Person author, Node n, Document doc) {
        Element authorNode = doc.createElement("author");
        if (author.getName() != null) {
            Element node = doc.createElement("name");
            node.appendChild(doc.createTextNode(author.getName()));
            authorNode.appendChild(node);
        }
        if (author.getEmail() != null) {
            this.addEmailToNode(author.getEmail(), authorNode, doc);
        }
        if (author.getLink() != null) {
            this.addLinkToNode(author.getLink(), authorNode, doc);
        }
        n.appendChild(authorNode);
    }

    private void addLinkToNode(Link link, Node n, Document doc) {
        Node node;
        Element linkNode = doc.createElement("link");
        NamedNodeMap attributes = linkNode.getAttributes();
        if (link.getHref() != null) {
            node = doc.createAttribute("href");
            node.setNodeValue(link.getHref());
            attributes.setNamedItem(node);
        }
        if (link.getText() != null) {
            node = doc.createElement("text");
            node.appendChild(doc.createTextNode(link.getText()));
            linkNode.appendChild(node);
        }
        if (link.getType() != null) {
            node = doc.createElement("type");
            node.appendChild(doc.createTextNode(link.getType()));
            linkNode.appendChild(node);
        }
        n.appendChild(linkNode);
    }

    private void addEmailToNode(Email email, Node n, Document doc) {
        Attr node;
        Element emailNode = doc.createElement("email");
        NamedNodeMap attributes = emailNode.getAttributes();
        if (email.getId() != null) {
            node = doc.createAttribute("id");
            node.setNodeValue(email.getId());
            attributes.setNamedItem(node);
        }
        if (email.getDomain() != null) {
            node = doc.createAttribute("domain");
            node.setNodeValue(email.getDomain());
            attributes.setNamedItem(node);
        }
        n.appendChild(emailNode);
    }

    private void addExtensionToNode(Extension e, Node n, Document doc) {
        if (e.getExtensionsParsed() > 0) {
            Element node = doc.createElement("extensions");
            for (IExtensionParser parser : this.extensionParsers) {
                parser.writeExtensions(e, node, doc);
            }
            n.appendChild(node);
        }
    }
}

