/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.gpxparser;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.himanshusoni.gpxparser.BaseGPX;
import me.himanshusoni.gpxparser.extension.DummyExtensionParser;
import me.himanshusoni.gpxparser.extension.IExtensionParser;
import me.himanshusoni.gpxparser.modal.Bounds;
import me.himanshusoni.gpxparser.modal.Copyright;
import me.himanshusoni.gpxparser.modal.Email;
import me.himanshusoni.gpxparser.modal.GPX;
import me.himanshusoni.gpxparser.modal.Link;
import me.himanshusoni.gpxparser.modal.Metadata;
import me.himanshusoni.gpxparser.modal.Person;
import me.himanshusoni.gpxparser.modal.Route;
import me.himanshusoni.gpxparser.modal.Track;
import me.himanshusoni.gpxparser.modal.TrackSegment;
import me.himanshusoni.gpxparser.modal.Waypoint;
import me.himanshusoni.gpxparser.type.Fix;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GPXParser
extends BaseGPX {
    private static final Pattern datevaluePattern = Pattern.compile("([0-9\\-T]+:[0-9]{2}:[0-9.+]+):([0-9]{2})");

    public GPX parseGPX(InputStream in) throws Exception {
        if (this.extensionParsers.isEmpty()) {
            this.extensionParsers.add(new DummyExtensionParser());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        Node firstChild = doc.getFirstChild();
        if (firstChild != null && "gpx".equals(firstChild.getNodeName())) {
            GPX gpx = new GPX();
            NamedNodeMap attrs = firstChild.getAttributes();
            for (int idx = 0; idx < attrs.getLength(); ++idx) {
                Node attr = attrs.item(idx);
                if ("version".equals(attr.getNodeName())) {
                    gpx.setVersion(attr.getNodeValue());
                    continue;
                }
                if ("creator".equals(attr.getNodeName())) {
                    gpx.setCreator(attr.getNodeValue());
                    continue;
                }
                if (!attr.getNodeName().startsWith("xmlns") && !attr.getNodeName().startsWith("xsi")) continue;
                gpx.addXmlns(attr.getNodeName(), attr.getNodeValue());
            }
            NodeList nodes = firstChild.getChildNodes();
            for (int idx = 0; idx < nodes.getLength(); ++idx) {
                Node currentNode = nodes.item(idx);
                if ("metadata".equals(currentNode.getNodeName())) {
                    Metadata m = this.parseMetadata(currentNode);
                    if (m == null) continue;
                    gpx.setMetadata(m);
                    continue;
                }
                if ("wpt".equals(currentNode.getNodeName())) {
                    Waypoint w = this.parseWaypoint(currentNode);
                    if (w == null) continue;
                    gpx.addWaypoint(w);
                    continue;
                }
                if ("rte".equals(currentNode.getNodeName())) {
                    Route rte = this.parseRoute(currentNode);
                    if (rte == null) continue;
                    gpx.addRoute(rte);
                    continue;
                }
                if ("trk".equals(currentNode.getNodeName())) {
                    Track trk = this.parseTrack(currentNode);
                    if (trk == null) continue;
                    gpx.addTrack(trk);
                    continue;
                }
                if (!"extensions".equals(currentNode.getNodeName())) continue;
                for (IExtensionParser parser : this.extensionParsers) {
                    Object data = parser.parseExtensions(currentNode);
                    gpx.addExtensionData(parser.getId(), data);
                }
            }
            return gpx;
        }
        throw new IllegalAccessException("Not a valid GPX file.");
    }

    private Metadata parseMetadata(Node node) throws DOMException {
        if (node == null) {
            return null;
        }
        Metadata m = new Metadata();
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int idx = 0; idx < childNodes.getLength(); ++idx) {
                Node currentNode = childNodes.item(idx);
                if ("name".equals(currentNode.getNodeName())) {
                    m.setName(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("desc".equals(currentNode.getNodeName())) {
                    m.setDesc(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("author".equals(currentNode.getNodeName())) {
                    Person author = this.parsePerson(currentNode);
                    if (author == null) continue;
                    m.setAuthor(author);
                    continue;
                }
                if ("copyright".equals(currentNode.getNodeName())) {
                    Copyright copyright = this.parseCopyright(currentNode);
                    if (copyright == null) continue;
                    m.setCopyright(copyright);
                    continue;
                }
                if ("link".equals(currentNode.getNodeName())) {
                    Link link = this.parseLink(currentNode);
                    if (link == null) continue;
                    m.addLink(link);
                    continue;
                }
                if ("time".equals(currentNode.getNodeName())) {
                    m.setTime(this.getNodeValueAsDate(currentNode));
                    continue;
                }
                if ("keywords".equals(currentNode.getNodeName())) {
                    m.setKeywords(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("bounds".equals(currentNode.getNodeName())) {
                    Bounds bounds = this.parseBounds(currentNode);
                    if (bounds == null) continue;
                    m.setBounds(bounds);
                    continue;
                }
                if (!"extensions".equals(currentNode.getNodeName())) continue;
                for (IExtensionParser parser : this.extensionParsers) {
                    Object data = parser.parseExtensions(currentNode);
                    m.addExtensionData(parser.getId(), data);
                }
            }
        }
        return m;
    }

    private Person parsePerson(Node node) {
        if (node == null) {
            return null;
        }
        Person p = new Person();
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int idx = 0; idx < childNodes.getLength(); ++idx) {
                Link link;
                Node currentNode = childNodes.item(idx);
                if ("name".equals(currentNode.getNodeName())) {
                    p.setName(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("email".equals(currentNode.getNodeName())) {
                    Email email = this.parseEmail(currentNode);
                    if (email == null) continue;
                    p.setEmail(email);
                    continue;
                }
                if (!"link".equals(currentNode.getNodeName()) || (link = this.parseLink(currentNode)) == null) continue;
                p.setLink(link);
            }
        }
        return p;
    }

    private Copyright parseCopyright(Node node) {
        if (node == null) {
            return null;
        }
        Copyright c = new Copyright(null);
        NamedNodeMap attrs = node.getAttributes();
        for (int idx = 0; idx < attrs.getLength(); ++idx) {
            Node attr = attrs.item(idx);
            if (!"author".equals(attr.getNodeName())) continue;
            c.setAuthor(attr.getNodeValue());
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int idx = 0; idx < childNodes.getLength(); ++idx) {
                Node currentNode = childNodes.item(idx);
                if ("year".equals(currentNode.getNodeName())) {
                    c.setYear(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if (!"license".equals(currentNode.getNodeName())) continue;
                c.setLicense(this.getNodeValueAsString(currentNode));
            }
        }
        return c;
    }

    private Link parseLink(Node node) {
        if (node == null) {
            return null;
        }
        Link l = new Link(null);
        NamedNodeMap attrs = node.getAttributes();
        for (int idx = 0; idx < attrs.getLength(); ++idx) {
            Node attr = attrs.item(idx);
            if (!"href".equals(attr.getNodeName())) continue;
            l.setHref(attr.getNodeValue());
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int idx = 0; idx < childNodes.getLength(); ++idx) {
                Node currentNode = childNodes.item(idx);
                if ("text".equals(currentNode.getNodeName())) {
                    l.setText(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if (!"type".equals(currentNode.getNodeName())) continue;
                l.setType(this.getNodeValueAsString(currentNode));
            }
        }
        return l;
    }

    private Bounds parseBounds(Node node) {
        if (node == null) {
            return null;
        }
        Bounds b = new Bounds(0.0, 0.0, 0.0, 0.0);
        NamedNodeMap attrs = node.getAttributes();
        for (int idx = 0; idx < attrs.getLength(); ++idx) {
            Node attr = attrs.item(idx);
            if ("minlat".equals(attr.getNodeName())) {
                b.setMinLat(Double.parseDouble(attr.getNodeValue()));
                continue;
            }
            if ("minlon".equals(attr.getNodeName())) {
                b.setMinLon(Double.parseDouble(attr.getNodeValue()));
                continue;
            }
            if ("maxlat".equals(attr.getNodeName())) {
                b.setMaxLat(Double.parseDouble(attr.getNodeValue()));
                continue;
            }
            if (!"maxlon".equals(attr.getNodeName())) continue;
            b.setMaxLon(Double.parseDouble(attr.getNodeValue()));
        }
        return b;
    }

    private Email parseEmail(Node node) {
        if (node == null) {
            return null;
        }
        Email e = new Email(null, null);
        NamedNodeMap attrs = node.getAttributes();
        for (int idx = 0; idx < attrs.getLength(); ++idx) {
            Node attr = attrs.item(idx);
            if ("id".equals(attr.getNodeName())) {
                e.setId(attr.getNodeValue());
                continue;
            }
            if (!"domain".equals(attr.getNodeName())) continue;
            e.setDomain(attr.getNodeValue());
        }
        return e;
    }

    private Waypoint parseWaypoint(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        Waypoint w = new Waypoint(0.0, 0.0);
        NamedNodeMap attrs = node.getAttributes();
        Node latNode = attrs.getNamedItem("lat");
        if (latNode == null) {
            throw new Exception("no lat value in waypoint data.");
        }
        double latVal = Double.parseDouble(latNode.getNodeValue());
        w.setLatitude(latVal);
        Node lonNode = attrs.getNamedItem("lon");
        if (lonNode == null) {
            throw new Exception("no lon value in waypoint data.");
        }
        double lonVal = Double.parseDouble(lonNode.getNodeValue());
        w.setLongitude(lonVal);
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int idx = 0; idx < childNodes.getLength(); ++idx) {
                Node currentNode = childNodes.item(idx);
                if ("ele".equals(currentNode.getNodeName())) {
                    w.setElevation(this.getNodeValueAsDouble(currentNode));
                    continue;
                }
                if ("time".equals(currentNode.getNodeName())) {
                    w.setTime(this.getNodeValueAsDate(currentNode));
                    continue;
                }
                if ("magvar".equals(currentNode.getNodeName())) {
                    w.setMagneticVariation(this.getNodeValueAsDouble(currentNode));
                    continue;
                }
                if ("geoidheight".equals(currentNode.getNodeName())) {
                    w.setGeoIdHeight(this.getNodeValueAsDouble(currentNode));
                    continue;
                }
                if ("name".equals(currentNode.getNodeName())) {
                    w.setName(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("cmt".equals(currentNode.getNodeName())) {
                    w.setComment(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("desc".equals(currentNode.getNodeName())) {
                    w.setDescription(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("src".equals(currentNode.getNodeName())) {
                    w.setSrc(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("link".equals(currentNode.getNodeName())) {
                    Link link = this.parseLink(currentNode);
                    if (link == null) continue;
                    w.addLink(link);
                    continue;
                }
                if ("sym".equals(currentNode.getNodeName())) {
                    w.setSym(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("type".equals(currentNode.getNodeName())) {
                    w.setType(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("fix".equals(currentNode.getNodeName())) {
                    w.setFix(this.getNodeValueAsFixType(currentNode));
                    continue;
                }
                if ("sat".equals(currentNode.getNodeName())) {
                    w.setSat(this.getNodeValueAsInteger(currentNode));
                    continue;
                }
                if ("hdop".equals(currentNode.getNodeName())) {
                    w.setHdop(this.getNodeValueAsDouble(currentNode));
                    continue;
                }
                if ("vdop".equals(currentNode.getNodeName())) {
                    w.setVdop(this.getNodeValueAsDouble(currentNode));
                    continue;
                }
                if ("pdop".equals(currentNode.getNodeName())) {
                    w.setPdop(this.getNodeValueAsDouble(currentNode));
                    continue;
                }
                if ("ageofdgpsdata".equals(currentNode.getNodeName())) {
                    w.setAgeOfGPSData(this.getNodeValueAsDouble(currentNode));
                    continue;
                }
                if ("dgpsid".equals(currentNode.getNodeName())) {
                    w.setdGpsStationId(this.getNodeValueAsInteger(currentNode));
                    continue;
                }
                if (!"extensions".equals(currentNode.getNodeName())) continue;
                for (IExtensionParser parser : this.extensionParsers) {
                    Object data = parser.parseExtensions(currentNode);
                    w.addExtensionData(parser.getId(), data);
                }
            }
        }
        return w;
    }

    private Route parseRoute(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        Route rte = new Route();
        NodeList nodes = node.getChildNodes();
        if (nodes != null) {
            for (int idx = 0; idx < nodes.getLength(); ++idx) {
                Waypoint wp;
                Node currentNode = nodes.item(idx);
                if ("name".equals(currentNode.getNodeName())) {
                    rte.setName(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("cmt".equals(currentNode.getNodeName())) {
                    rte.setComment(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("desc".equals(currentNode.getNodeName())) {
                    rte.setDescription(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("src".equals(currentNode.getNodeName())) {
                    rte.setSrc(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("link".equals(currentNode.getNodeName())) {
                    Link link = this.parseLink(currentNode);
                    if (link == null) continue;
                    rte.addLink(link);
                    continue;
                }
                if ("number".equals(currentNode.getNodeName())) {
                    rte.setNumber(this.getNodeValueAsInteger(currentNode));
                    continue;
                }
                if ("type".equals(currentNode.getNodeName())) {
                    rte.setType(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("extensions".equals(currentNode.getNodeName())) {
                    Iterator it = this.extensionParsers.iterator();
                    while (it.hasNext()) {
                        while (it.hasNext()) {
                            IExtensionParser parser = (IExtensionParser)it.next();
                            Object data = parser.parseExtensions(currentNode);
                            rte.addExtensionData(parser.getId(), data);
                        }
                    }
                    continue;
                }
                if (!"rtept".equals(currentNode.getNodeName()) || (wp = this.parseWaypoint(currentNode)) == null) continue;
                rte.addRoutePoint(wp);
            }
        }
        return rte;
    }

    private Track parseTrack(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        Track trk = new Track();
        NodeList nodes = node.getChildNodes();
        if (nodes != null) {
            for (int idx = 0; idx < nodes.getLength(); ++idx) {
                TrackSegment trackSeg;
                Node currentNode = nodes.item(idx);
                if ("name".equals(currentNode.getNodeName())) {
                    trk.setName(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("cmt".equals(currentNode.getNodeName())) {
                    trk.setComment(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("desc".equals(currentNode.getNodeName())) {
                    trk.setDescription(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("src".equals(currentNode.getNodeName())) {
                    trk.setSrc(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("link".equals(currentNode.getNodeName())) {
                    Link link = this.parseLink(currentNode);
                    if (link == null) continue;
                    trk.addLink(link);
                    continue;
                }
                if ("number".equals(currentNode.getNodeName())) {
                    trk.setNumber(this.getNodeValueAsInteger(currentNode));
                    continue;
                }
                if ("type".equals(currentNode.getNodeName())) {
                    trk.setType(this.getNodeValueAsString(currentNode));
                    continue;
                }
                if ("extensions".equals(currentNode.getNodeName())) {
                    Iterator it = this.extensionParsers.iterator();
                    while (it.hasNext()) {
                        while (it.hasNext()) {
                            IExtensionParser parser = (IExtensionParser)it.next();
                            Object data = parser.parseExtensions(currentNode);
                            trk.addExtensionData(parser.getId(), data);
                        }
                    }
                    continue;
                }
                if (!"trkseg".equals(currentNode.getNodeName()) || (trackSeg = this.parseTrackSegment(currentNode)) == null) continue;
                trk.addTrackSegment(trackSeg);
            }
        }
        return trk;
    }

    private TrackSegment parseTrackSegment(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        TrackSegment ts = new TrackSegment();
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int idx = 0; idx < childNodes.getLength(); ++idx) {
                Node currentNode = childNodes.item(idx);
                if ("trkpt".equals(currentNode.getNodeName())) {
                    Waypoint w = this.parseWaypoint(currentNode);
                    if (w == null) continue;
                    ts.addWaypoint(w);
                    continue;
                }
                if (!"extensions".equals(currentNode.getNodeName())) continue;
                Iterator it = this.extensionParsers.iterator();
                while (it.hasNext()) {
                    while (it.hasNext()) {
                        IExtensionParser parser = (IExtensionParser)it.next();
                        Object data = parser.parseExtensions(currentNode);
                        ts.addExtensionData(parser.getId(), data);
                    }
                }
            }
        }
        return ts;
    }

    private Date getNodeValueAsDate(Node node) throws DOMException {
        Date val = null;
        try {
            String parseValue;
            String nodeValue = node.getFirstChild().getNodeValue();
            if (!nodeValue.endsWith("Z")) {
                nodeValue = nodeValue + "Z";
            }
            val = (parseValue = datevaluePattern.matcher(nodeValue).replaceAll("$1$2")).length() == 24 ? xmlDateFormatWithMilli.parse(parseValue) : xmlDateFormat.parse(parseValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    private Double getNodeValueAsDouble(Node node) {
        return Double.parseDouble(node.getFirstChild().getNodeValue());
    }

    private Fix getNodeValueAsFixType(Node node) {
        return Fix.returnType(node.getFirstChild().getNodeValue());
    }

    private Integer getNodeValueAsInteger(Node node) {
        return Integer.parseInt(node.getFirstChild().getNodeValue());
    }

    private String getNodeValueAsString(Node node) {
        if (node == null) {
            return null;
        }
        Node child = node.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue();
    }
}

