/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.edittextspinner;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Canvas;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;

public class EditTextSpinner<T extends Listable>
extends AppCompatEditText {
    List<T> mItems;
    String[] mListableItems;
    CharSequence mHint = this.getHint();
    OnItemSelectedListener<T> onItemSelectedListener;

    public EditTextSpinner(Context context) {
        super(context);
    }

    public EditTextSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EditTextSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.setFocusable(false);
        this.setClickable(true);
    }

    public void setItems(List<T> items) {
        this.mItems = items;
        this.mListableItems = new String[items.size()];
        int i = 0;
        for (Listable item : this.mItems) {
            this.mListableItems[i++] = item.getLabel();
        }
        this.configureOnClickListener();
    }

    private void configureOnClickListener() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
                builder.setTitle(EditTextSpinner.this.mHint);
                builder.setItems((CharSequence[])EditTextSpinner.this.mListableItems, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int selectedIndex) {
                        EditTextSpinner.this.setText(EditTextSpinner.this.mListableItems[selectedIndex]);
                        if (EditTextSpinner.this.onItemSelectedListener != null) {
                            EditTextSpinner.this.onItemSelectedListener.onItemSelectedListener(EditTextSpinner.this.mItems.get(selectedIndex), selectedIndex);
                        }
                    }
                });
                builder.setPositiveButton(0x1040000, null);
                builder.create().show();
            }
        });
    }

    public void setOnItemSelectedListener(OnItemSelectedListener<T> onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public static interface Listable {
        public String getLabel();
    }

    public static interface OnItemSelectedListener<T> {
        public void onItemSelectedListener(T var1, int var2);
    }
}

