/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.chatmessageview;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

public class ChatMessageDrawable
extends Drawable {
    private final Paint mPaint;
    private final RectF mBoundsF;
    private final Rect mBoundsI;
    private float mRadius;
    private float mPadding;
    private boolean mInsetForPadding;
    private boolean mInsetForRadius = true;

    public ChatMessageDrawable(int backgroundColor, float radius) {
        this.mRadius = radius;
        this.mPaint = new Paint(5);
        this.mPaint.setColor(backgroundColor);
        this.mBoundsF = new RectF();
        this.mBoundsI = new Rect();
    }

    void setPadding(float padding, boolean insetForPadding, boolean insetForRadius) {
        if (padding == this.mPadding && this.mInsetForPadding == insetForPadding && this.mInsetForRadius == insetForRadius) {
            return;
        }
        this.mPadding = padding;
        this.mInsetForPadding = insetForPadding;
        this.mInsetForRadius = insetForRadius;
        this.updateBounds(null);
        this.invalidateSelf();
    }

    float getPadding() {
        return this.mPadding;
    }

    public void draw(Canvas canvas) {
        canvas.drawRoundRect(this.mBoundsF, this.mRadius, this.mRadius, this.mPaint);
    }

    private void updateBounds(Rect bounds) {
        if (bounds == null) {
            bounds = this.getBounds();
        }
        this.mBoundsF.set((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom);
        this.mBoundsI.set(bounds);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updateBounds(bounds);
    }

    public void getOutline(Outline outline) {
        outline.setRoundRect(this.mBoundsI, this.mRadius);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -3;
    }

    public float getRadius() {
        return this.mRadius;
    }

    void setRadius(float radius) {
        if (radius == this.mRadius) {
            return;
        }
        this.mRadius = radius;
        this.updateBounds(null);
        this.invalidateSelf();
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
        this.invalidateSelf();
    }

    public Paint getPaint() {
        return this.mPaint;
    }
}

