/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.chatmessageview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;

public final class TintedBitmapDrawable
extends BitmapDrawable {
    private int tint;
    private int alpha;

    public TintedBitmapDrawable(Resources res, Bitmap bitmap, int tint) {
        super(res, bitmap);
        this.tint = tint;
        this.alpha = Color.alpha((int)tint);
    }

    public TintedBitmapDrawable(Resources res, int resId, int tint) {
        super(res, BitmapFactory.decodeResource((Resources)res, (int)resId));
        this.tint = tint;
        this.alpha = Color.alpha((int)tint);
    }

    public void setTint(int tint) {
        this.tint = tint;
        this.alpha = Color.alpha((int)tint);
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        Paint paint = this.getPaint();
        if (paint.getColorFilter() == null) {
            paint.setColorFilter((ColorFilter)new LightingColorFilter(this.tint, 0));
            paint.setAlpha(this.alpha);
        }
        super.draw(canvas);
    }
}

