/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.chatmessageview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import me.himanshusoni.chatmessageview.ChatMessageDrawable;
import me.himanshusoni.chatmessageview.ChatMessageStateDrawable;
import me.himanshusoni.chatmessageview.R;
import me.himanshusoni.chatmessageview.TintedBitmapDrawable;
import me.himanshusoni.chatmessageview.util.ViewUtil;

public class ChatMessageView
extends RelativeLayout {
    private ImageView arrowImage;
    private RelativeLayout containerLayout;
    private TintedBitmapDrawable normalDrawable;
    private TintedBitmapDrawable pressedDrawable;
    private float cornerRadius;
    private float contentPadding;
    private float arrowMargin;
    private boolean showArrow;
    private ArrowPosition arrowPosition;
    private ArrowGravity arrowGravity;
    private int backgroundColor;
    private int backgroundColorPressed;

    public ChatMessageView(Context context) {
        super(context);
        this.initialize(null, 0);
    }

    public ChatMessageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(attrs, 0);
    }

    public ChatMessageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(attrs, defStyleAttr);
    }

    private void initialize(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChatMessageView, defStyleAttr, 0);
        this.showArrow = a.getBoolean(R.styleable.ChatMessageView_cmv_showArrow, true);
        this.arrowMargin = a.getDimension(R.styleable.ChatMessageView_cmv_arrowMargin, (float)this.dip2px(5.0f));
        this.cornerRadius = a.getDimension(R.styleable.ChatMessageView_cmv_cornerRadius, 0.0f);
        this.contentPadding = a.getDimension(R.styleable.ChatMessageView_cmv_contentPadding, (float)this.dip2px(10.0f));
        this.backgroundColor = a.getColor(R.styleable.ChatMessageView_cmv_backgroundColor, 0);
        this.backgroundColorPressed = a.getColor(R.styleable.ChatMessageView_cmv_backgroundColorPressed, 0);
        int intPosition = a.getInt(R.styleable.ChatMessageView_cmv_arrowPosition, ArrowPosition.LEFT.getValue());
        this.arrowPosition = ArrowPosition.getEnum(intPosition);
        int intGravity = a.getInt(R.styleable.ChatMessageView_cmv_arrowGravity, ArrowGravity.START.getValue());
        this.arrowGravity = ArrowGravity.getEnum(intGravity);
        a.recycle();
        this.initContent();
    }

    public void setArrowPosition(ArrowPosition position) {
        this.arrowPosition = position;
    }

    public void setArrowGravity(ArrowGravity gravity) {
        this.arrowGravity = gravity;
    }

    public void setBackgroundColorRes(@ColorRes int bgColorRes, @ColorRes int bgPressedColorRes) {
        this.backgroundColorPressed = ContextCompat.getColor((Context)this.getContext(), (int)bgPressedColorRes);
        this.backgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)bgColorRes);
        this.updateColors();
    }

    public void setBackgroundColor(@ColorInt int bgColorRes, @ColorInt int bgPressedColorRes) {
        this.backgroundColorPressed = bgPressedColorRes;
        this.backgroundColor = bgColorRes;
        this.updateColors();
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        if (child != this.arrowImage && child != this.containerLayout) {
            this.removeView(child);
            this.containerLayout.addView(child);
        }
    }

    @TargetApi(value=21)
    private void initContent() {
        int arrowRotation;
        this.arrowImage = new ImageView(this.getContext());
        this.arrowImage.setId(ViewUtil.generateViewId());
        if (!this.showArrow) {
            this.arrowImage.setVisibility(4);
        }
        this.containerLayout = new RelativeLayout(this.getContext());
        this.containerLayout.setId(ViewUtil.generateViewId());
        this.containerLayout.setPadding((int)this.contentPadding, (int)this.contentPadding, (int)this.contentPadding, (int)this.contentPadding);
        RelativeLayout.LayoutParams conRlParams = new RelativeLayout.LayoutParams(-2, -2);
        RelativeLayout.LayoutParams arrowParams = new RelativeLayout.LayoutParams(-2, -2);
        switch (this.arrowPosition) {
            case LEFT: {
                arrowRotation = 180;
                arrowParams.addRule(9);
                arrowParams.setMargins(0, (int)this.arrowMargin, 0, (int)this.arrowMargin);
                conRlParams.addRule(1, this.arrowImage.getId());
                break;
            }
            case TOP: {
                arrowRotation = 270;
                arrowParams.setMargins((int)this.arrowMargin, 0, (int)this.arrowMargin, 0);
                conRlParams.addRule(3, this.arrowImage.getId());
                break;
            }
            case BOTTOM: {
                arrowRotation = 90;
                arrowParams.setMargins((int)this.arrowMargin, 0, (int)this.arrowMargin, 0);
                arrowParams.addRule(3, this.containerLayout.getId());
                break;
            }
            default: {
                arrowRotation = 0;
                arrowParams.addRule(11);
                arrowParams.setMargins(0, (int)this.arrowMargin, 0, (int)this.arrowMargin);
                conRlParams.addRule(0, this.arrowImage.getId());
            }
        }
        switch (this.arrowGravity) {
            case START: {
                if (this.arrowPosition == ArrowPosition.TOP || this.arrowPosition == ArrowPosition.BOTTOM) {
                    arrowParams.addRule(9);
                    break;
                }
                arrowParams.addRule(10);
                break;
            }
            case CENTER: {
                if (this.arrowPosition == ArrowPosition.TOP || this.arrowPosition == ArrowPosition.BOTTOM) {
                    arrowParams.addRule(14);
                    break;
                }
                arrowParams.addRule(15);
                break;
            }
            case END: {
                if (this.arrowPosition == ArrowPosition.TOP || this.arrowPosition == ArrowPosition.BOTTOM) {
                    arrowParams.addRule(11);
                    break;
                }
                arrowParams.addRule(12);
            }
        }
        int arrowRes = R.drawable.cmv_arrow;
        Bitmap source = BitmapFactory.decodeResource((Resources)this.getResources(), (int)arrowRes);
        Bitmap rotateBitmap = this.rotateBitmap(source, arrowRotation);
        this.normalDrawable = new TintedBitmapDrawable(this.getResources(), rotateBitmap, this.backgroundColor);
        this.pressedDrawable = new TintedBitmapDrawable(this.getResources(), rotateBitmap, this.backgroundColorPressed);
        this.arrowImage.setImageDrawable((Drawable)this.normalDrawable);
        super.addView((View)this.arrowImage, (ViewGroup.LayoutParams)arrowParams);
        super.addView((View)this.containerLayout, (ViewGroup.LayoutParams)conRlParams);
        if (Build.VERSION.SDK_INT >= 21) {
            this.arrowImage.setImageTintList(ColorStateList.valueOf((int)this.backgroundColor));
        }
        this.updateColors();
        this.setClickable(true);
    }

    @TargetApi(value=21)
    private void updateColors() {
        ChatMessageDrawable roundRectDrawable = new ChatMessageDrawable(this.backgroundColor, this.cornerRadius);
        if (Build.VERSION.SDK_INT >= 16) {
            this.containerLayout.setBackground((Drawable)roundRectDrawable);
        } else {
            this.containerLayout.setBackgroundDrawable((Drawable)roundRectDrawable);
        }
        this.normalDrawable.setTint(this.backgroundColor);
        this.pressedDrawable.setTint(this.backgroundColorPressed);
        if (Build.VERSION.SDK_INT >= 21) {
            this.arrowImage.setImageTintList(ColorStateList.valueOf((int)this.backgroundColor));
        }
        ChatMessageStateDrawable stateDrawable = new ChatMessageStateDrawable(0){

            @Override
            protected void onIsPressed(boolean isPressed) {
                ChatMessageDrawable conRlBackground = (ChatMessageDrawable)ChatMessageView.this.containerLayout.getBackground();
                if (isPressed) {
                    conRlBackground.setColor(ChatMessageView.this.backgroundColorPressed);
                    ChatMessageView.this.arrowImage.setImageDrawable((Drawable)ChatMessageView.this.pressedDrawable);
                } else {
                    conRlBackground.setColor(ChatMessageView.this.backgroundColor);
                    ChatMessageView.this.arrowImage.setImageDrawable((Drawable)ChatMessageView.this.normalDrawable);
                }
                ChatMessageView.this.containerLayout.invalidate();
                ChatMessageView.this.arrowImage.invalidate();
            }
        };
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)stateDrawable);
        } else {
            this.setBackgroundDrawable((Drawable)stateDrawable);
        }
    }

    public Bitmap rotateBitmap(Bitmap source, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static enum ArrowGravity {
        START(0),
        CENTER(1),
        END(2);

        int value;

        private ArrowGravity(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ArrowGravity getEnum(int value) {
            switch (value) {
                case 0: {
                    return START;
                }
                case 1: {
                    return CENTER;
                }
                case 2: {
                    return END;
                }
            }
            return START;
        }
    }

    public static enum ArrowPosition {
        LEFT(0),
        RIGHT(1),
        TOP(2),
        BOTTOM(3);

        int value;

        private ArrowPosition(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ArrowPosition getEnum(int value) {
            switch (value) {
                case 0: {
                    return LEFT;
                }
                case 1: {
                    return RIGHT;
                }
                case 2: {
                    return TOP;
                }
                case 3: {
                    return BOTTOM;
                }
            }
            return LEFT;
        }
    }
}

