/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.core;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.Window;
import android.widget.TextView;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.widgets.CircularRevealFrameLayout;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MdCompat {
    public static void applyLeading(TextView view, int dimensionPixelSize) {
        float spacing = 0.0f;
        if (dimensionPixelSize > 0) {
            Paint.FontMetricsInt metrics = view.getPaint().getFontMetricsInt();
            spacing = dimensionPixelSize - (metrics.descent - metrics.ascent);
        }
        view.setLineSpacing(spacing, 1.0f);
    }

    @TargetApi(value=11)
    public static Animator createCircularReveal(CircularRevealFrameLayout view, int centerX, int centerY, float startRadius, float endRadius) {
        Animator animator;
        final WeakReference<CircularRevealFrameLayout> viewRef = new WeakReference<CircularRevealFrameLayout>(view);
        ((CircularRevealFrameLayout)((Object)viewRef.get())).setVisibility(4);
        if (Build.VERSION.SDK_INT >= 21) {
            animator = ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)startRadius, (float)endRadius);
        } else {
            view.setClipOutLines(true);
            view.setClipCenter(centerX, centerY);
            animator = ObjectAnimator.ofFloat((Object)((Object)view), (String)"Radius", (float[])new float[]{startRadius, endRadius});
        }
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                CircularRevealFrameLayout view = (CircularRevealFrameLayout)((Object)viewRef.get());
                if (view != null) {
                    view.setClipOutLines(false);
                }
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationStart(Animator animation) {
                CircularRevealFrameLayout view = (CircularRevealFrameLayout)((Object)viewRef.get());
                if (view != null) {
                    view.setVisibility(0);
                }
            }
        });
        return animator;
    }

    public static Drawable createDrawableTint(Drawable drawable, int[] drawableState, ColorStateList tintList, PorterDuff.Mode tintMode) {
        if (drawable != null && (tintList != null || tintMode != null)) {
            drawable = DrawableCompat.wrap((Drawable)drawable).mutate();
            if (tintList != null) {
                DrawableCompat.setTintList((Drawable)drawable, (ColorStateList)tintList);
            }
            if (tintMode != null) {
                DrawableCompat.setTintMode((Drawable)drawable, (PorterDuff.Mode)tintMode);
            }
            if (drawable.isStateful() && drawableState != null) {
                drawable.setState(drawableState);
            }
        }
        return drawable;
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static void enableTranslucentStatus(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.setFlags(0x4000000, 0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
        }
    }

    public static int getActionBarSize(Context context) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{16843499});
        int size = (int)a.getDimension(0, 0.0f);
        a.recycle();
        return size;
    }

    public static boolean getBooleanFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return false;
        }
        TypedArray array = context.getTheme().obtainStyledAttributes(new int[]{R.attr.isLightTheme});
        return array.getBoolean(0, false);
    }

    public static int getColorFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return 0;
        }
        TypedValue a = new TypedValue();
        context.getTheme().resolveAttribute(attrId, a, true);
        return ContextCompat.getColor((Context)context, (int)a.resourceId);
    }

    public static ColorStateList getColorStateList(Context context, int resId) throws IOException, XmlPullParserException {
        int depth;
        int type;
        XmlResourceParser parser = context.getResources().getXml(resId);
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        Resources r = context.getResources();
        int innerDepth = parser.getDepth() + 2;
        ArrayList<int[]> customStateList = new ArrayList<int[]>();
        ArrayList<Integer> customColorList = new ArrayList<Integer>();
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int color = 0;
            float alpha = 1.0f;
            int[] stateSpec = new int[numAttrs];
            block7: for (int i = 0; i < numAttrs; ++i) {
                int stateResId = attrs.getAttributeNameResource(i);
                switch (stateResId) {
                    case 16843173: {
                        int colorAttrId = attrs.getAttributeResourceValue(i, 0);
                        if (colorAttrId == 0) {
                            String colorAttrValue = attrs.getAttributeValue(i);
                            colorAttrId = Integer.valueOf(colorAttrValue.replace("?", ""));
                            color = MdCompat.getColorFromAttribute(context, colorAttrId);
                            continue block7;
                        }
                        color = ContextCompat.getColor((Context)context, (int)colorAttrId);
                        continue block7;
                    }
                    case 16843551: {
                        try {
                            alpha = attrs.getAttributeFloatValue(i, 1.0f);
                        }
                        catch (Exception e) {
                            String alphaAttrValue = attrs.getAttributeValue(i);
                            alpha = MdCompat.getFloatFromAttribute(context, Integer.valueOf(alphaAttrValue.replace("?", "")));
                        }
                        continue block7;
                    }
                    default: {
                        stateSpec[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
                    }
                }
            }
            stateSpec = StateSet.trimStateSet((int[])stateSpec, (int)j);
            color = MdCompat.modulateColorAlpha(color, alpha);
            customColorList.add(color);
            customStateList.add(stateSpec);
        }
        int[] colors = new int[customColorList.size()];
        int[][] states = new int[customStateList.size()][];
        int n = states.length;
        for (int i = 0; i < n; ++i) {
            colors[i] = (Integer)customColorList.get(i);
            states[i] = (int[])customStateList.get(i);
        }
        return new ColorStateList((int[][])states, colors);
    }

    public static float getFloatFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return 0.0f;
        }
        TypedValue a = new TypedValue();
        context.getTheme().resolveAttribute(attrId, a, true);
        return a.getFloat();
    }

    public static int getResourceIdFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return 0;
        }
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrId, typedValue, true);
        return typedValue.resourceId;
    }

    public static int getStatusBarSize(Context context) {
        int id;
        int statusBarSize = 0;
        if (context != null && (id = context.getResources().getIdentifier("status_bar_height", "dimen", "android")) > 0) {
            statusBarSize = context.getResources().getDimensionPixelSize(id);
        }
        return statusBarSize;
    }

    public static String getStringFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return null;
        }
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrId, typedValue, true);
        CharSequence result = typedValue.string;
        return !TextUtils.isEmpty((CharSequence)result) ? result.toString() : null;
    }

    public static boolean isLightTheme(Context context) {
        return MdCompat.getBooleanFromAttribute(context, R.attr.isLightTheme);
    }

    public static int modulateColorAlpha(int baseColor, float alphaMod) {
        if (alphaMod == 1.0f) {
            return baseColor;
        }
        int alpha = (int)((float)Color.alpha((int)baseColor) * alphaMod + 0.5f);
        alpha = Math.min(Math.max(alpha, 0), 255);
        return ColorUtils.setAlphaComponent((int)baseColor, (int)alpha);
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            default: {
                return defaultMode;
            }
            case 0: {
                return PorterDuff.Mode.CLEAR;
            }
            case 1: {
                return PorterDuff.Mode.SRC;
            }
            case 2: {
                return PorterDuff.Mode.DST;
            }
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 4: {
                return PorterDuff.Mode.DST_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 6: {
                return PorterDuff.Mode.DST_IN;
            }
            case 7: {
                return PorterDuff.Mode.SRC_OUT;
            }
            case 8: {
                return PorterDuff.Mode.DST_OUT;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 10: {
                return PorterDuff.Mode.DST_ATOP;
            }
            case 11: {
                return PorterDuff.Mode.XOR;
            }
            case 16: {
                return PorterDuff.Mode.DARKEN;
            }
            case 17: {
                return PorterDuff.Mode.LIGHTEN;
            }
            case 13: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 14: {
                return PorterDuff.Mode.SCREEN;
            }
            case 12: {
                return Build.VERSION.SDK_INT >= 11 ? PorterDuff.Mode.valueOf((String)"ADD") : defaultMode;
            }
            case 15: 
        }
        return Build.VERSION.SDK_INT >= 11 ? PorterDuff.Mode.valueOf((String)"OVERLAY") : defaultMode;
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static Drawable supportDrawableTint(Context context, Drawable drawable, Palette palette) {
        try {
            int resId = 0;
            switch (palette) {
                case PRIMARY: {
                    resId = MdCompat.getResourceIdFromAttribute(context, R.attr.mdIconColor_primaryPalette);
                    break;
                }
                case ACCENT: {
                    resId = MdCompat.getResourceIdFromAttribute(context, R.attr.mdIconColor_accentPalette);
                    break;
                }
                case WARN: {
                    resId = MdCompat.getResourceIdFromAttribute(context, R.attr.mdIconColor_warnPalette);
                    break;
                }
                case BACKGROUND: {
                    resId = MdCompat.getResourceIdFromAttribute(context, R.attr.mdIconColor_backgroundPalette);
                }
            }
            return MdCompat.createDrawableTint(drawable, null, MdCompat.getColorStateList(context, resId), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return drawable;
    }

    public static void supportDrawableTint(Context context, Menu menu, Palette palette) {
        if (menu != null) {
            int n = menu.size();
            for (int i = 0; i < n; ++i) {
                MdCompat.supportDrawableTint(context, menu.getItem(i), palette);
            }
        }
    }

    public static void supportDrawableTint(Context context, MenuItem menuItem, Palette palette) {
        if (menuItem != null) {
            menuItem.setIcon(MdCompat.supportDrawableTint(context, menuItem.getIcon(), Palette.PRIMARY));
            if (menuItem.hasSubMenu()) {
                MdCompat.supportDrawableTint(context, (Menu)menuItem.getSubMenu(), palette);
            }
        }
    }

    public static void supportDrawableTint(Context context, Toolbar toolbar, Palette palette) {
        if (toolbar != null) {
            toolbar.setNavigationIcon(MdCompat.supportDrawableTint(context, toolbar.getNavigationIcon(), palette));
        }
    }

    public static void supportDrawableTint(Context context, Toolbar toolbar) {
        MdCompat.supportDrawableTint(context, toolbar, Palette.PRIMARY);
    }

    public static enum Palette {
        PRIMARY,
        ACCENT,
        WARN,
        BACKGROUND;

    }
}

