/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.Typography;

public class MdToolbar
extends Toolbar {
    private boolean mInit;
    private Typeface mSubtitleTypeface;
    private Typeface mTitleTypeface;

    public MdToolbar(Context context) {
        this(context, null);
    }

    public MdToolbar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.toolbarStyle);
    }

    public MdToolbar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr > 0 ? defStyleAttr : R.attr.toolbarStyle);
        this.initFromAttributes(attrs, defStyleAttr > 0 ? defStyleAttr : R.attr.toolbarStyle);
    }

    public void setSubtitle(CharSequence subtitle) {
        super.setSubtitle(Typography.applyTypeface(subtitle, this.mSubtitleTypeface));
    }

    public void setTitle(CharSequence title) {
        super.setTitle(Typography.applyTypeface(title, this.mTitleTypeface));
    }

    private void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.titleTextAppearance, R.attr.subtitleTextAppearance}, defStyleAttr, 0);
        int titleTextAppearanceResourceId = a.getResourceId(0, 0);
        int subtitleTextAppearanceResourceId = a.getResourceId(1, 0);
        a.recycle();
        if (titleTextAppearanceResourceId > 0) {
            this.mTitleTypeface = Typography.getTypeface(this.getContext(), titleTextAppearanceResourceId);
        }
        if (subtitleTextAppearanceResourceId > 0) {
            this.mSubtitleTypeface = Typography.getTypeface(this.getContext(), subtitleTextAppearanceResourceId);
        }
    }
}

