/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.ViewUtils;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.Typography;

public class MdCheckBox
extends AppCompatCheckBox {
    private int mDrawablePadding;
    private boolean mHasCustomDrawable;
    private int mMinWidth;
    private int mPaddingBottom;
    private int mPaddingLeft;
    private int mPaddingRight;
    private int mPaddingTop;

    private static int getDefStyleAttr(Context context, AttributeSet attrs) {
        return MdCheckBox.hasCustomDrawable(context, attrs) ? R.attr.MdIconToggleStyle : R.attr.MdCheckBoxStyle;
    }

    private static boolean hasCustomDrawable(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.srcCompat}, 0, 0);
        boolean result = a.getResourceId(0, 0) > 0;
        a.recycle();
        return result;
    }

    public MdCheckBox(Context context) {
        this(context, null);
    }

    public MdCheckBox(Context context, AttributeSet attrs) {
        this(context, attrs, MdCheckBox.getDefStyleAttr(context, attrs));
    }

    public MdCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr > 0 ? defStyleAttr : MdCheckBox.getDefStyleAttr(context, attrs));
        this.initFromAttributes(attrs, defStyleAttr > 0 ? defStyleAttr : MdCheckBox.getDefStyleAttr(context, attrs));
    }

    protected void onDraw(Canvas canvas) {
        if (this.isLayoutRtl()) {
            canvas.translate((float)(-this.mPaddingRight), 0.0f);
        } else {
            canvas.translate((float)this.mPaddingLeft, 0.0f);
        }
        super.onDraw(canvas);
        Drawable background = this.getBackground();
        if (Build.VERSION.SDK_INT >= 21 && background != null) {
            boolean isLayoutRtl = this.isLayoutRtl();
            Rect bounds = background.getBounds();
            int top = bounds.top;
            int bottom = bounds.bottom;
            int left = (isLayoutRtl ? this.getWidth() - this.mMinWidth : 0) + (!this.mHasCustomDrawable && !isLayoutRtl ? this.mPaddingLeft : 0);
            int right = (isLayoutRtl ? this.getWidth() : this.mMinWidth) - (!this.mHasCustomDrawable && isLayoutRtl ? this.mPaddingRight : 0);
            background.setHotspotBounds(left, top, right, bottom);
        }
    }

    protected void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        Typeface typeface = Typography.getTypeface(this.getContext(), attrs, defStyleAttr, 0);
        if (typeface != null) {
            this.setTypeface(typeface);
        }
        this.mHasCustomDrawable = MdCheckBox.hasCustomDrawable(this.getContext(), attrs);
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingTop = this.getPaddingTop();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingBottom = this.getPaddingBottom();
        this.mDrawablePadding = this.getCompoundDrawablePadding();
        this.mMinWidth = ViewCompat.getMinimumWidth((View)this);
        this.invalidatePadding();
        this.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                MdCheckBox.this.invalidatePadding();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
    }

    private void invalidatePadding() {
        int adjustedLeft = TextUtils.isEmpty((CharSequence)this.getText()) ? 0 : this.mDrawablePadding;
        int adjustedRight = this.mPaddingLeft + this.mPaddingRight;
        if (Build.VERSION.SDK_INT >= 16) {
            this.setPaddingRelative(adjustedLeft, this.mPaddingTop, adjustedRight, this.mPaddingBottom);
        } else {
            this.setPadding(adjustedLeft, this.mPaddingTop, adjustedRight, this.mPaddingBottom);
        }
    }

    private boolean isLayoutRtl() {
        return ViewUtils.isLayoutRtl((View)this);
    }
}

