/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;

@TargetApi(value=11)
public class CircularRevealFrameLayout
extends FrameLayout {
    private float mCenterX;
    private float mCenterY;
    private boolean mIsClipOutlines;
    private boolean mIsShouldNotClipOutlines;
    private float mRadius;
    private Path mRevealPath;

    public CircularRevealFrameLayout(Context context) {
        super(context);
        this.init();
    }

    public CircularRevealFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CircularRevealFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public CircularRevealFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void draw(Canvas canvas) {
        if (!this.mIsClipOutlines || this.mIsShouldNotClipOutlines) {
            super.draw(canvas);
            return;
        }
        try {
            int state = canvas.save();
            this.mRevealPath.reset();
            this.mRevealPath.addCircle(this.mCenterX, this.mCenterY, this.mRadius, Path.Direction.CW);
            canvas.clipPath(this.mRevealPath);
            super.draw(canvas);
            canvas.restoreToCount(state);
        }
        catch (Exception ignore) {
            this.mIsShouldNotClipOutlines = true;
        }
    }

    public void setClipCenter(int x, int y) {
        this.mCenterX = x;
        this.mCenterY = y;
    }

    public void setClipOutLines(boolean isClipOutlines) {
        this.mIsClipOutlines = isClipOutlines;
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
    }

    private void init() {
        this.mRevealPath = new Path();
        this.mIsClipOutlines = false;
        if (Build.VERSION.SDK_INT <= 18) {
            this.setLayerType(1, null);
        }
        this.setWillNotDraw(false);
    }
}

