/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets.arcanimator;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.support.v4.view.ViewCompat;
import android.view.View;
import java.lang.ref.WeakReference;
import me.henrytao.mdcore.widgets.arcanimator.ArcMetric;
import me.henrytao.mdcore.widgets.arcanimator.Side;
import me.henrytao.mdcore.widgets.arcanimator.Utils;

@TargetApi(value=11)
public class ArcAnimator
extends ValueAnimator {
    public static ArcAnimator create(View target, float endX, float endY, float degree, Side side) {
        ArcMetric arcMetric = ArcMetric.evaluate(Utils.centerX(target), Utils.centerY(target), endX, endY, degree, side);
        return new ArcAnimator(arcMetric, target);
    }

    protected ArcAnimator(ArcMetric arcMetric, View target) {
        this.setFloatValues(new float[]{arcMetric.getStartDegree(), arcMetric.getEndDegree()});
        this.addUpdateListener(new AnimatorUpdateListener(arcMetric, target));
    }

    private static class AnimatorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private final ArcMetric mArcMetric;
        private final WeakReference<View> mTarget;

        public AnimatorUpdateListener(ArcMetric arcMetric, View target) {
            this.mArcMetric = arcMetric;
            this.mTarget = new WeakReference<View>(target);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            View target = (View)this.mTarget.get();
            if (target != null) {
                float degree = ((Float)animation.getAnimatedValue()).floatValue();
                float x = this.mArcMetric.getAxisPoint().x + this.mArcMetric.mRadius * Utils.cos(degree);
                float y = this.mArcMetric.getAxisPoint().y - this.mArcMetric.mRadius * Utils.sin(degree);
                ViewCompat.setX((View)target, (float)(x - (float)(target.getMeasuredWidth() / 2)));
                ViewCompat.setY((View)target, (float)(y - (float)(target.getMeasuredHeight() / 2)));
            }
        }
    }
}

